% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_documentation.R
\docType{data}
\name{pr2_ex_data}
\alias{pr2_ex_data}
\title{Example of PR2 SSU data}
\format{An object of type \code{\link{taxmap}}}
\usage{
pr2_ex_data
}
\description{
A dataset containing information from 249 Stramenopile sequences from the PR2 reference database.
}
\examples{
\dontrun{

file_path <- system.file("extdata", "pr2_stramenopiles_gb203.fasta", package = "metacoder")
sequences <- ape::read.FASTA(file_path)
pr2_ex_data <- extract_taxonomy(sequences,
                                regex = "^(.*\\\\..*?)\\\\|(.*)$",
                                key = c("obs_id", "class"),
                                class_sep = "\\\\|")
}

}
\keyword{datasets}
