% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_taxonomy.R
\name{parse_taxonomy_table}
\alias{parse_taxonomy_table}
\title{Parse taxonomic data in a tsv/csv file}
\usage{
parse_taxonomy_table(input, taxon_col, other_col_type = "obs_info",
  header = TRUE, sep = "\\t", max_lines = NULL, comment_prefix = "#",
  ...)
}
\arguments{
\item{input}{(\code{character} of length 1)
The file path to the input file or a \code{data.frame}.}

\item{taxon_col}{(named \code{integer} of length 1)
The index of the column with taxonomic information, named by the type of information.
A negative index is interpreted as the number of columns from the last.
The name of the column can have to following values:
 \describe{
   \item{\code{taxon_id}}{A unique numeric id for a taxon for a particular \code{database} (e.g. ncbi accession number).
         Requires an internet connection.}
   \item{\code{name}}{The name of a taxon. Not necessarily unique, but are interpretable
         by a particular \code{database}. Requires an internet connection.}
   \item{\code{class}}{A list of taxa information that constitutes the full taxonomic classification
         from broad to specific (see \code{class_rev}) for a particular \code{database}. Individual taxa
         are separated by the \code{class_sep} argument and the information is parsed by the
         \code{class_regex} and \code{class_key} arguments.}
 }}

\item{other_col_type}{(\code{character}) 
The type of the other columns no specified by \code{taxon_col}. Can be \code{"taxon_info"} or \code{"obs_info"}.}

\item{header}{(\code{logical} of length 1)
If \code{TRUE}, the first row of the file is the column names.}

\item{sep}{(\code{character} of length 1)
The character(s) that separate each column in each row.
Can be a regular expression.}

\item{max_lines}{(\code{integer} of length 1)
The maximum number of lines to read from the file.}

\item{comment_prefix}{(\code{character}) One or more characters that appear at the start of a line indicating that the line is a comment and not part of the data.}

\item{...}{Passed to \code{\link{extract_taxonomy}}.}
}
\value{
\code{\link{taxmap}}
}
\description{
Parse taxonomic data in a tsv/csv file
}
