% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxmap--class.R
\name{taxon_data}
\alias{taxon_data}
\title{Return taxon data from \code{\link{taxmap}}}
\usage{
taxon_data(obj, row_subset = NULL, col_subset = NULL,
  calculated_cols = TRUE, sort_by = NULL, decreasing = FALSE,
  drop = FALSE)
}
\arguments{
\item{obj}{(\code{\link{taxmap}})}

\item{row_subset}{(\code{character})
The taxon_ids of a subset of \code{obj}.
Default: All rows.}

\item{col_subset}{(\code{character})
The names of columns, either user defined or generated using \code{taxon_funcs}.
Default: All columns.}

\item{calculated_cols}{(\code{logical} of length 1)
If \code{TRUE}, return calculated columns using  functions in \code{\link{taxmap}$taxon_funcs}.
These values are calculated each time \code{taxon_data} is called since their values can change if 
the data is subset.}

\item{sort_by}{(\code{character} of length 1)
The name of a column in \code{obj$taxon_data} or a function name in  \code{obj$taxon_funcs}.
This column will be used to sort the output rows.
If \code{NULL}, no sorting will be done.}

\item{decreasing}{(\code{logical} of length 1)
If \code{TRUE}, \code{sort_by} order is decreasing.}

\item{drop}{(\code{logical} of length 1)
If \code{TRUE}, if \code{subset} is a single column
name, then a \code{vector} is returned instead of a \code{data.frame}}
}
\value{
A \code{data.frame} or \code{vector} with rows corresponding to taxa in input
}
\description{
Return a table of data associated with taxa of and object of type
\code{\link{taxmap}}.
}

