% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metabias-class.R, R/methods.R
\name{metabias-class}
\alias{metabias-class}
\alias{metabias}
\alias{new_metabias}
\alias{summary.metabias}
\title{metabias S3 class}
\usage{
metabias(
  data = data.frame(),
  values = list(),
  stats = data.frame(),
  fits = list()
)

new_metabias(x = list())

\method{summary}{metabias}(object, ...)
}
\arguments{
\item{data}{Dataframe containing data used to fit the model(s), with added
columns for any values computed during model fitting.}

\item{values}{List of values of arguments passed to the function.}

\item{stats}{Dataframe of summary statistics from the model fit(s).}

\item{fits}{List of fitted objects (which have a class that depends on the
underlying fitting methods, e.g. \code{\link[robumeta:robu]{robumeta::robu}} or \code{\link[rstan:stanfit-class]{rstan::stanfit}}).}

\item{x}{List with elements "data", "values", "stats", "fits".}

\item{object}{Object of class \code{metabias}.}

\item{...}{Not used.}
}
\value{
An object of class \code{metabias}, which consists of a list containing
the elements \code{data}, \code{values}, \code{stats}, \code{fits} (corresponding to the
arguments passed).
}
\description{
A object of class \code{metabias} is the result of fitting one or
more models to a dataset with one row per study being meta-analyzed. These
models are either (1) a meta-analysis with a correction for one or more
within-study or across-study biases, or (2) a sensitivity analysis for
meta-analyses with respect to these biases. Examples of functions that
return such objects include:
\itemize{
\item \code{PublicationBias::pubbias_meta()}
\item \code{PublicationBias::pubbias_svalue()}
\item \code{phacking::phacking_meta()}
\item \code{multibiasmeta::multibias_meta()}
\item \code{multibiasmeta::multibias_evalue()}
}
}
\examples{
# example model from robumeta::robu()
hier_mod <- robumeta::robu(effectsize ~ binge + followup + sreport + age,
                           data = robumeta::hierdat, studynum = studyid,
                           var.eff.size = var, modelweights = "HIER",
                           small = TRUE)

ci <- 0.95  # example set value
hier_mb <- metabias(data = robumeta::hierdat,                 # data passed to model
                    values = list(ci_level = ci),             # value used
                    stats = robu_ci(hier_mod, ci_level = ci), # stats from model
                    fits = list("robu" = hier_mod))           # model object

hier_mb
summary(hier_mb)
}
