% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_stand_RR.R
\name{es_from_rr_ci}
\alias{es_from_rr_ci}
\title{Convert a risk ratio value and 95\% confidence interval to various effect size measures}
\usage{
es_from_rr_ci(
  rr,
  rr_ci_lo,
  rr_ci_up,
  logrr,
  logrr_ci_lo,
  logrr_ci_up,
  baseline_risk,
  n_exp,
  n_nexp,
  n_cases,
  n_controls,
  rr_to_or = "metaumbrella",
  smd_to_cor = "viechtbauer",
  max_asymmetry = 10,
  reverse_rr
)
}
\arguments{
\item{rr}{risk ratio value}

\item{rr_ci_lo}{lower bound of the 95\% CI around the risk ratio value}

\item{rr_ci_up}{upper bound of the 95\% CI around the risk ratio value}

\item{logrr}{log risk ratio value}

\item{logrr_ci_lo}{lower bound of the 95\% CI around the log risk ratio value}

\item{logrr_ci_up}{upper bound of the 95\% CI around the log risk ratio value}

\item{baseline_risk}{proportion of cases in the non-exposed group (only required for the \code{rr_to_or = "grant_CI"} and \code{rr_to_or = "grant_2x2"} arguments).}

\item{n_exp}{number of participants in the exposed group (only required for the \code{rr_to_or = "grant_CI"}, \code{rr_to_or = "grant_2x2"} arguments).}

\item{n_nexp}{number of participants in the non-exposed group (only required for the \code{rr_to_or = "grant_CI"}, \code{rr_to_or = "grant_2x2"} arguments).}

\item{n_cases}{number of cases/events}

\item{n_controls}{number of controls/no-event}

\item{rr_to_or}{formula used to convert the \code{rr} value into an odds ratio (see details).}

\item{smd_to_cor}{formula used to convert the SMD value (converted from RR) into a coefficient correlation (see \code{\link{es_from_cohen_d}}).}

\item{max_asymmetry}{A percentage indicating the tolerance before detecting asymmetry in the 95\% CI bounds.}

\item{reverse_rr}{a logical value indicating whether the direction of the generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab RR\cr
\tab \cr
\code{converted effect size measure} \tab OR + NNT\cr
\tab \cr
\code{required input data} \tab See 'Section 3. Risk Ratio'\cr
\tab https://metaconvert.org/input.html\cr
\tab \cr
}
}
\description{
Convert a risk ratio value and 95\% confidence interval to various effect size measures
}
\details{
This function uses the 95\% CI of the (log) risk ratio to obtain the standard error (Section 6.5.2.2 in the Cochrane Handbook).
\deqn{logrr\_se = \frac{\log{rr\_ci\_up} - \log{rr\_ci\_lo}}{2 * qnorm(.975)}}

Then, calculations of the \code{\link{es_from_rr_se}()} are applied.
}
\examples{
es_from_rr_ci(
  rr = 1, rr_ci_lo = 0.5, rr_ci_up = 2,
  n_cases = 42, n_controls = 38, baseline_risk = 0.08
)
}
\references{
Higgins JPT, Li T, Deeks JJ (editors). Chapter 6: Choosing effect size measures and computing estimates of effect. In: Higgins JPT, Thomas J, Chandler J, Cumpston M, Li T, Page MJ, Welch VA (editors). Cochrane Handbook for Systematic Reviews of Interventions version 6.3 (updated February 2022). Cochrane, 2022. Available from www.training.cochrane.org/handbook.
}
