% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapSiteFinder.R
\name{mapSiteFinder}
\alias{mapSiteFinder}
\title{Map environmental monitoring stations}
\usage{
mapSiteFinder(x, limit = 5000)
}
\arguments{
\item{x}{(list) Metadata of environmental monitoring stations.}

\item{limit}{(numeric) maximum number of stations to plot.  Defaults to 5000.  Setting this >5000 may result in wait times of up to minute if internet connection is slow.}
}
\value{
A map of environmental monitoring stations
}
\description{
A plotting tool to map environmetnal monitoring stations from the metScanR database.  **NOTE: This function requires internet connection!**
}
\examples{
\dontrun{
#map environmental monitoring stations located in Italy
  mapSiteFinder(getCountry(country="Italy"))
#map environmental monitoring stations within 50 km of Boulder, CO, USA
  mapSiteFinder(getNearby(lat=40.0149,lon=-105.2705,radius=50))}

}
\seealso{
\link[metScanR]{getNearby}
\link[metScanR]{getElevation}
\link[metScanR]{getDates}
\link[metScanR]{getNetwork}
\link[metScanR]{getVars}
\link[metScanR]{getCountry}
\link[metScanR]{getId}
\link[metScanR]{siteFinder}
\link[metScanR]{metScanR_DB}
}
\author{
Josh Roberti \email{jaroberti87@gmail.com} \cr
Lee Stanish \cr
Cody Flagg \cr
Sam Weintraub \cr
Derek Smith
}
