% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTerritory.R
\name{getTerritory}
\alias{getTerritory}
\title{Filter environmental monitoring stations by state/territory}
\usage{
getTerritory(territory, ...)
}
\arguments{
\item{territory}{(character) state/territory abbreviation (e.g., 'RI'= Rhode Island, United States;'YT' = Yukon Territory, Canada)to filter environmental monitoring stations. \cr
\cr}

\item{...}{auto-populates when called from \code{siteFinder()} wrapper}
}
\value{
A list comprising metadata of environmental monitoring sites from state/territory specified in \code{network}\cr
}
\description{
Return metadata of environmental monitoring stations from a state/territory within the metScanR database.
}
\examples{
\dontrun{
#returns metadata from all stations within Rhode Island (RI)
  getTerritory(territory = "RI")
#returns metadata from stations within Colorado and Utah
  getTerritory(territory=c("CO","UT"))}
}
\references{
see reference links above
}
\seealso{
\link[metScanR]{siteFinder}
\link[metScanR]{mapSiteFinder}
\link[metScanR]{metScanR_DB}
}
\author{
Josh Roberti \email{jaroberti87@gmail.com} \cr
}
\keyword{AL}
\keyword{ASOS,}
\keyword{AWOS,}
\keyword{BOR,}
\keyword{COCORAHS,}
\keyword{COOP,}
\keyword{MPRC,}
\keyword{MSNT,}
\keyword{NEON,}
\keyword{SCAN,}
\keyword{SNOW,}
\keyword{SNTL,}
\keyword{SNTLT,}
\keyword{UPPERAIT,}
\keyword{USCRN,}
\keyword{USGS,}
\keyword{USRCRN}
\keyword{air}
\keyword{air,}
\keyword{atmopsheric}
\keyword{atmosphere,}
\keyword{canopy,}
\keyword{chemical,}
\keyword{climate,}
\keyword{cloud,}
\keyword{conductivity,}
\keyword{data,}
\keyword{environment,}
\keyword{environmental}
\keyword{flux,}
\keyword{groundwater,}
\keyword{humidity,}
\keyword{in-situ,}
\keyword{lake,}
\keyword{metadata,}
\keyword{phenology,}
\keyword{pollution,}
\keyword{precipitation,}
\keyword{radiation,}
\keyword{reservoir,}
\keyword{river,}
\keyword{salinity,}
\keyword{snow,}
\keyword{soil,}
\keyword{soils,}
\keyword{stream,}
\keyword{temperature,}
\keyword{vapor,}
\keyword{water,}
\keyword{weather,}
\keyword{wind,}
