% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getNetwork.R
\name{getNetwork}
\alias{getNetwork}
\title{Filter environmental monitoring stations by network}
\usage{
getNetwork(network, ...)
}
\arguments{
\item{network}{(character) Network(s)/platform(s) to filter environmental monitoring stations. Metadata are available for stations in the networks below.  See reference links for further information.\cr
\cr
AL USRCRN: United States Regional Climate Reference Network - Alabama \cr
\url{https://catalog.data.gov/dataset/al-usrcrn-station-information}\cr
\cr
Ameriflux\cr
\url{http://ameriflux.lbl.gov/sites/site-search/#filter-type=all}\cr
\cr
ASOS: Automated Surface Observing System \cr
\url{https://www.ncdc.noaa.gov/data-access/land-based-station-data/land-based-datasets/automated-surface-observing-system-asos}\cr
\cr
AWOS: Automated Weather Observing System \cr
\url{https://www.ncdc.noaa.gov/data-access/land-based-station-data/land-based-datasets/automated-weather-observing-system-awos}\cr
\cr
BOR: Bureau of Reclamation \cr
\url{https://www.wcc.nrcs.usda.gov/wsf/wsf-reservoir.html}\cr
\cr
COCORAHS: Community Collaborative Rain, Hail & Snow Network \cr
\url{https://www.cocorahs.org/}\cr
\cr
COOP: Cooperative Observer Network \cr
\url{https://www.ncdc.noaa.gov/data-access/land-based-station-data/land-based-datasets/cooperative-observer-network-coop}\cr
\cr
NEON: National Ecological Observatory Network \cr
\url{http://www.neonscience.org/}\cr
\cr
NADP: National Atmospheric Deposition Program\cr
\url{http://nadp.slh.wisc.edu/airmon/}\cr
\cr
NRCS: Natural Resources Conservation Service \cr
\url{https://www.wcc.nrcs.usda.gov/web_service/NRCS_Station_Networks.pdf}\cr
\cr
UKN: *unknown* (unidentifed network)\cr
\cr
UPPERAIR: Upper Air network \cr
\url{https://www.weather.gov/upperair/nws_upper}\cr
\cr
USCRN: United States Climate Reference Network \cr
\url{https://www.ncdc.noaa.gov/crn/} \cr
\cr
USGS: Streamflow Network (United States Geological Survey) \cr
\url{https://water.usgs.gov/nsip/} \cr
\cr
USRCRN: United States Regional Climate Reference Network \cr
\url{https://www.ncdc.noaa.gov/crn/}\cr}

\item{...}{auto-populates when called from \code{siteFinder()} wrapper}
}
\value{
A list comprising metadata of environmental monitoring sites from network(s)/platform(s) specified in \code{network}\cr
}
\description{
Return metadata of environmental monitoring stations from networks/platforms within the metScanR database.
}
\examples{
\dontrun{
#returns metadata from all SCAN sites within the database
  getNetwork(network="SCAN")
#returns metadata from ASOS, COOP, USCRN, and NEON sites within the database
  getNetwork(network=c("ASOS","COOP","USCRN","NEON"))}
}
\references{
see reference links above
}
\seealso{
\link[metScanR]{siteFinder}
\link[metScanR]{mapSiteFinder}
\link[metScanR]{metScanR_DB}
}
\author{
Josh Roberti \email{jaroberti87@gmail.com} \cr
Derek Smith
}
\keyword{AL}
\keyword{ASOS,}
\keyword{AWOS,}
\keyword{BOR,}
\keyword{COCORAHS,}
\keyword{COOP,}
\keyword{MPRC,}
\keyword{MSNT,}
\keyword{NEON,}
\keyword{SCAN,}
\keyword{SNOW,}
\keyword{SNTL,}
\keyword{SNTLT,}
\keyword{UPPERAIT,}
\keyword{USCRN,}
\keyword{USGS,}
\keyword{USRCRN}
\keyword{air}
\keyword{air,}
\keyword{atmopsheric}
\keyword{atmosphere,}
\keyword{canopy,}
\keyword{chemical,}
\keyword{climate,}
\keyword{cloud,}
\keyword{conductivity,}
\keyword{data,}
\keyword{environment,}
\keyword{environmental}
\keyword{flux,}
\keyword{groundwater,}
\keyword{humidity,}
\keyword{in-situ,}
\keyword{lake,}
\keyword{metadata,}
\keyword{phenology,}
\keyword{pollution,}
\keyword{precipitation,}
\keyword{radiation,}
\keyword{reservoir,}
\keyword{river,}
\keyword{salinity,}
\keyword{snow,}
\keyword{soil,}
\keyword{soils,}
\keyword{stream,}
\keyword{temperature,}
\keyword{vapor,}
\keyword{water,}
\keyword{weather,}
\keyword{wind,}
