% Generated by roxygen2 (4.0.2): do not edit by hand
\name{neLht}
\alias{neEffdecomp}
\alias{neEffdecomp.neModel}
\alias{neLht}
\alias{neLht.neModelBoot}
\title{Linear hypotheses for natural effect models}
\usage{
neEffdecomp(model, ...)

\method{neEffdecomp}{neModel}(model, ...)

neLht(model, ...)

\method{neLht}{neModelBoot}(model, ...)
}
\arguments{
\item{model}{a fitted natural effect model object.}

\item{...}{additional arguments (passed to \code{\link[multcomp]{glht}}).}
}
\value{
An object of class \code{c("neLhtBoot", "neLht", "glht")} (see \code{\link[multcomp]{glht}}). \code{neEffdecomp} returns an object that additionally inherits from class \code{"neEffdecomp"}.

See \code{\link{neLht-methods}} for methods for \code{neLht} objects (and \code{\link[=coef.glht]{glht-methods}} for additional methods for \code{glht} objects).
}
\description{
\code{neLht} allows to calculate linear combinations of natural effect model parameter estimates.\cr \code{neEffdecomp} automatically extracts relevant causal parameter estimates from a natural effect model.
}
\details{
\code{neLht} is a wrapper of \code{\link[multcomp]{glht}} and offers the same functionality (see `Details' section of  \code{\link[multcomp]{glht}} for details on argument specification).
It returns objects that inherit from the class \code{"neLht"} in order to make output of their corresponding methods (see \code{\link{neLht-methods}}) more compatible for natural effect models
containing bootstrap variance-covariance matrices and standard errors.

\code{neEffdecomp} is a convenience function that automatically extracts causal parameter estimates from a natural effect model
and derives natural effect components.
That is, natural direct, natural indirect and total causal effect estimates are returned if no exposure-mediator interaction is modelled (i.e. two-way decomposition).
If mediated interaction is allowed for in the natural effect model, there are two ways of decomposing the total effect into (natural) direct and indirect effects components:
either as the sum of the pure direct and the total indirect effect or as the sum of the pure indirect and the total direct effect (i.e. three-way decomposition).
In total, five causal effect estimates are returned in this case.
}
\note{
\code{neEffdecomp} is internally called by \code{\link{plot.neModel}} to create confidence interval plots for \code{neModel} objects.
}
\examples{
data(UPBdata)

impData <- neImpute(UPB ~ att * negaffect + gender + educ + age,
                    family = binomial, data = UPBdata)
\donttest{neMod <- neModel(UPB ~ att0 * att1 + gender + educ + age,
                 family = binomial, expData = impData)}\dontshow{neMod <- neModel(UPB ~ att0 * att1 + gender + educ + age, family = binomial, expData = impData, nBoot = 2)}

lht <- neLht(neMod, linfct = c("att0 = 0", "att0 + att0:att1 = 0",
                               "att1 = 0", "att1 + att0:att1 = 0",
                               "att0 + att1 + att0:att1 = 0"))
summary(lht)

## or obtain directly via neEffdecomp
eff <- neEffdecomp(neMod)
summary(eff)
}
\seealso{
\code{\link{plot.neLht}}, \code{\link{neLht-methods}}, \code{\link[multcomp]{glht}}, \code{\link[=coef.glht]{glht-methods}}, \code{\link{neModel}}, \code{\link{plot.neModel}}
}

