% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrbrthemes.R
\name{md_theme_ft_rc}
\alias{md_theme_ft_rc}
\alias{md_theme_ipsum}
\alias{md_theme_ipsum_ps}
\alias{md_theme_ipsum_rc}
\alias{md_theme_ipsum_tw}
\alias{md_theme_modern_rc}
\title{hrbrthemes Markdown Themes}
\usage{
md_theme_ft_rc(...)

md_theme_ipsum(...)

md_theme_ipsum_ps(...)

md_theme_ipsum_rc(...)

md_theme_ipsum_tw(...)

md_theme_modern_rc(...)
}
\arguments{
\item{...}{Arguments passed on to the corresponding theme in package \code{{hrbrthemes}}}
}
\value{
An object of class \code{theme} that can be added to any \code{ggplot}
}
\description{
\code{{hrbrthemes}} themes supporting markdown syntax
}
\examples{
library(ggplot2)
data(mtcars)

p <- ggplot(mtcars, aes(hp, mpg)) +
  geom_point() +
  labs(
    title = "A **bold** title",
    subtitle = "An *italics* subtitle",
    caption = "A <span style = 'color:blue'>blue</span> caption"
  )

# With a 'usual' theme the text is not rendered
p

# By adding an 'md' theme the text is rendered properly
p + md_theme_ipsum("sans")

}
\seealso{
\code{\link[=as_md_theme]{as_md_theme()}}
}
