% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MclustBounded.R
\name{MclustBoundedParameters}
\alias{MclustBoundedParameters}
\title{Recover parameters in the original scale}
\usage{
MclustBoundedParameters(object, nsim = 1e+06, ...)
}
\arguments{
\item{object}{An object of class \code{'MclustBounded'} or \code{'densityMclustBounded'}.}

\item{nsim}{An integer specifying the number of simulations to employ.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\description{
Given a GMM for bounded data, computes the means and variances in the
original scale from the estimated mixture components parameters dataset
using simulations.
}
\examples{
\donttest{
x = rlnorm(1000, 0, 1)
mod = densityMclustBounded(x, lbound = 0, lambda = 0)
summary(mod, parameters = TRUE)
plot(mod, what = "density")
# transformed parameters (from log-normal distribution)
# mean
with(mod$parameters, 
     exp(mean + 0.5*variance$sigmasq))
# var
with(mod$parameters,
     (exp(variance$sigmasq) - 1)*exp(2*mean + variance$sigmasq))
# using simulations
MclustBoundedParameters(mod)
}

}
