% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcen.r
\name{cluster.vals}
\alias{cluster.vals}
\title{Returns the cluster values from a cv.mcen object.}
\usage{
cluster.vals(obj)
}
\arguments{
\item{obj}{The cv.mcen object.}
}
\value{
Returns the clusters from the model with the smallest cross-validation error.
}
\description{
Returns the cluster values from a cv.mcen object.
}
\examples{
\donttest{
x <- matrix(rnorm(400),ncol=4)
beta <- beta <- matrix(c(1,1,0,0,0,0,-1,-1,0,0,-1,-1,1,1,0,0),ncol=4)
y <- x\%*\%beta + rnorm(400) 
mcen_fit <- cv.mcen(x,y,ky=2,gamma_y=3)
mcen_cluster <- cluster.vals(mcen_fit)
}
}
\author{
Ben Sherwood <ben.sherwood@ku.edu>, Brad Price <brad.price@mail.wvu.edu>
}
