% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr_test.R
\name{corr_test}
\alias{corr_test}
\title{Correlation Coefficient Test}
\usage{
corr_test(x, y, conf.int = 0.9, auto = TRUE, method = "pearson",
  SESOI = 0.1, plot = FALSE)
}
\arguments{
\item{x, y}{numeric vectors of data values}

\item{conf.int}{(optional) confidence level of the interval. Defaults to \code{0.90}}

\item{auto}{(character) logical indicator specifying if user wants function to programmatically detect statistical procedures. Defaults to \code{TRUE}}

\item{method}{(character) if \code{auto = F}, logical indicator specifying which correlation to execute (\code{pearson, spearman, kendall}). Defaults to \code{"pearson"}.}

\item{SESOI}{(optional) number indicating smallest worthwhile change. Defaults to \code{0.1}}

\item{plot}{(optional) logical indicator specifying to print associated plot. Defaults to \code{FALSE}}
}
\value{
Associated effect size measure, \emph{r}, and respective confidence intervals.
}
\description{
Provides magnitude-based inferences for the association between given data vectors. Evaluates normality assumption, performs either Pearson or Spearman correlation and subsequently estimates magnitude-based inferences.
}
\details{
Refer to vignette for further information.
}
\examples{
a <- rnorm(25, 80, 35)
b <- rnorm(25, 100, 35)

corr_test(a, b, 0.95)
}
