% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Eval.Utilities.R
\name{Eval.Utilities}
\alias{Eval.Utilities}
\title{Evaluate utilities}
\usage{
Eval.Utilities(index, columns, functions)
}
\arguments{
\item{index}{data.table of indexes}

\item{columns}{columns with indexes where the utilities will be computed}

\item{functions}{vector of characters with name of functions}
}
\value{
data.table with utilities
}
\description{
Evaluaction of utilities for a data.table of indexes, the utilities functions are 
computed over every index represented by each column of the input table.
}
\details{
The baisc MAUT models are built with functions of constant absolute risk aversion, 
this functions could be defined with simple parameters, \code{\link{Read.Utilities}} could 
interpret a basic text file with and standarized definition for every utility function.
}
\examples{
# Index
library( data.table )
index<-data.table( cod = c( 'A', 'B', 'C', 'D' ), 
                   i1 = c( 0.3428570, 1, 1, 1 ),
                   i2 = c( 0.5, 0.5, 1, 0.5 ), 
                   i3 = c( 0.5, 1.0, 0.75, 0.25 ),
                   i4 = c( 0, 0.2696746, 0.6751261, 0.7401660 ),
                   i5 = c( 0.2797259, 0.2981198, 1, 0.1952864 ) )

# Loading utilities
file<-system.file("extdata", "utilities.txt", package = "mau" )
script<-'utilities.R'
lines<-17
skip<-2
encoding<-'utf-8'
functions<-Read.Utilities( file, script, lines, skip, encoding )
source( 'utilities.R' )

# Index positions
columns<-c( 2, 3, 4, 5 )

# Associated names of functions
functions<-sapply( c( 'Project', 'Self implementation', 'External and local relations', 
                      'Scope of capabilities' ),
                   FUN = Stand.String )
names( functions )<-NULL

# Evaluation of utilities
utilities<-Eval.Utilities( index, columns, functions )
}
\author{
Pedro Guarderas, Andrés Lopez
}
\seealso{
\code{\link{Read.Utilities}}, \code{\link{Stand.String}}
}

