% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{subsetting}
\alias{subsetting}
\alias{[.matrixset}
\alias{[.row_grouped_ms}
\alias{[.col_grouped_ms}
\alias{[.dual_grouped_ms}
\alias{$.matrixset}
\alias{[[.matrixset}
\title{Subsetting  matrixsets}
\usage{
\method{[}{matrixset}(
  x,
  i = NULL,
  j = NULL,
  matrix = NULL,
  drop = FALSE,
  keep_annotation = TRUE,
  warn_class_change = getOption("matrixset.warn_class_change")
)

\method{[}{row_grouped_ms}(
  x,
  i = NULL,
  j = NULL,
  matrix = NULL,
  drop = FALSE,
  keep_annotation = TRUE,
  warn_class_change = getOption("matrixset.warn_class_change")
)

\method{[}{col_grouped_ms}(
  x,
  i = NULL,
  j = NULL,
  matrix = NULL,
  drop = FALSE,
  keep_annotation = TRUE,
  warn_class_change = getOption("matrixset.warn_class_change")
)

\method{[}{dual_grouped_ms}(
  x,
  i = NULL,
  j = NULL,
  matrix = NULL,
  drop = FALSE,
  keep_annotation = TRUE,
  warn_class_change = getOption("matrixset.warn_class_change")
)

\method{$}{matrixset}(x, matrix)

\method{[[}{matrixset}(x, matrix)
}
\arguments{
\item{x}{\code{matrixset} object from which to extract
element(s)}

\item{i, j}{rows (\code{i}) and columns (\code{j}) to extract from
matrices of \code{x}, as indices. These are either \code{numeric} or \code{character}
values.

To extract every rows or columns, use \code{i = NULL} or \code{j = NULL}, which is
the default for both. Note that treating \code{NULL} as empty differs from the
usual extraction, where it is treated as \code{integer(0)}.

Numeric values are coerced to integer through \code{\link[=as.integer]{as.integer()}}, which means
they are truncated towards zero.

Character vectors will be matched to the dimnames of the object.

Indices an also be logical vectors, stating for each element if it is
extracted (\code{TRUE}) or rejected (\code{FALSE}). Logical vectors are \emph{NOT}
recycled, which is an important difference with usual matrix extraction.
It means that the \code{logical} vector must match the object dimension in
length.

Can also be negative integers, in which case they are indices of elements
to leave out of the selection.

When indexing, a single argument \code{i} can be a matrix with two columns.
This is treated as if the first column was the \code{i} index and the second
column the \code{j} index.}

\item{matrix}{index specifying matrix or matrices to extract.
Index is numeric or character vectors or empty
(\code{NULL}). Note that treating \code{NULL} as
empty differs from the usual extraction, where it
is treated as \code{integer(0)}. Here a
\code{NULL} (empty) results in selecting all
matrices.

See arguments \verb{i,j}, as the same rules are followed.}

\item{drop}{If \code{TRUE}, the \code{drop} option of matrix extraction
is used. See [\code{[}()]. Note that the default for
\code{matrixset} objects is \code{FALSE}.}

\item{keep_annotation}{\code{logical} specifying if the resulting object
should keep the annotations (meta info, or
traits, as per \code{matrixset} notation) as part
of the object. The default (\code{TRUE}), combined
with the default \code{drop = FALSE}, guarantees that
the resulting object is a \code{matrixset} object. If
\code{keep_annotation} is \code{FALSE}, the resulting
object will be a list of matrix, and a warning
will be issued, unless \code{warn_class_change} is
\code{FALSE}.}

\item{warn_class_change}{\code{logical} that determines if a warning
should be issued when the extraction result is
not a \code{matrixset}. The default is to use
the global option \code{"matrixset.warn_class_change"},
which is \code{FALSE} by default. If one wants
to silence permanently this warning, this is the
option to change.}
}
\value{
The resulting object type depends on the subsetting options. By default, a
\code{matrixset} object will be returned. This object will have the following
properties:
\itemize{
\item Rows and/or columns are a subset of the input (based on what has been
subsetted), but appear in the same order.
\item Annotations, or traits, are subsetted appropriately.
\item The number of groups may be reduced.
\item Currently, attributes are \emph{not} preserved.
}

If \code{keep_annotation} is \code{FALSE}, the resulting object will be a list.
Typically, it will be a list of \code{matrix}, but if \code{drop} is \code{TRUE}, some
list elements could be vectors.
}
\description{
Extract parts of a matrixset, where indexes refers to rows and columns.
}
\details{
Indexes \code{i} and \code{j} are given as for a regular \code{\link[=matrix]{matrix()}}
(note however that factors are currently not allowed for indexing).
Which matrices are extracted (all or a subset) is specified via argument
\code{"matrix"}.

Missing values (\code{NA}) are not allowed for indexing, as it results in
unknown selection. Character indexes use exact matching, not partial.

The default arguments for \code{"drop"} and \code{"keep_annotation"} are
chosen so that the object resulting from the extraction is still a
\code{matrixset}.

Setting \code{"keep_annotation"} to \code{FALSE} automatically results in a class
change (a list of matrix) and a warning is issued (see argument
\code{warn_class_change}, however).

Setting \code{drop} to \code{TRUE} may also result to a change of class,
depending on the provided indices (the same way matrix may result to a vector
when \code{drop} is \code{TRUE}).

The subsetting operator \code{[[} is a convenient wrapper for \verb{[(,,matrix)}.

There is no \code{$} subsetting operator for the \code{matrixset} object.
}
\section{Grouped matrixset}{

When subsetting a grouped \code{matrixset} (by rows and/or columns), when the
resulting object is still a \code{matrixset}, the grouping structure will be
updated based on the resulting data.
}

\examples{
lst <- list(a = matrix(1:6, 2, 3), b = matrix(101:106, 2, 3), c = NULL)
rownames(lst$a) <- rownames(lst$b) <- c("r1", "r2")
colnames(lst$a) <- colnames(lst$b) <- c("c1", "c2", "c3")
ri <- data.frame(rowname = c("r1", "r2"), g = 1:2)
ci <- data.frame(colname = c("c1", "c2", "c3"), h = 1:3)
matset <- matrixset(lst, row_info = ri, column_info = ci, row_tag = "foo", column_tag = "bar")

# this doesn't subset anything, just returns matset again
matset[]

# this extracts the first row of every matrix. Note how each matrices is
# still a matrix, so you still end up with a matrixset object. Note also
# that you need placeholder for j and matrix index, even when not provided
matset[1, , ]

# similar idea
matset[,2, ]
matset[1,2,]

# it obviously works with vector indexes
matset[1:2, c(1,3),]

# you can extract the matrices this - even without the 'annoying' warning
matset[, , , keep_annotation = FALSE]
matset[, , , keep_annotation = FALSE, warn_class_change = FALSE]

# extracts subsetted matrices (no annotations)
matset[1, , , keep_annotation = FALSE, warn_class_change = FALSE]

# a bit more in line with how R subsets matrices
matset[1, , , drop = TRUE, warn_class_change = FALSE]

# you can obviously get some of the matrices only
matset[,,1]
matset[c(1,2),,1:2]

# to showcase other kind of indexes. These are all equivalents
matset[1,,]
matset["r1", ,]
matset[c(TRUE, FALSE), ,]
matset[-2, ,] # equivalent because there are only 2 rows

# this is also equivalent
matset[,,1]
matset[[1]]

}
