% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixpls.R
\name{matrixpls-functions}
\alias{matrixpls-functions}
\title{All estimation function types}
\arguments{
\item{weightFun}{A function for calculating indicator weights using the data covariance matrix
\code{S}, a model specification \code{model}, and a weight pattern \code{W.model}. Returns
a weight matrix \code{W}. The default is \code{\link{weightFun.pls}}}

\item{parameterEstim}{A function for estimating the model parameters using
the data covariance matrix \code{S}, model specification \code{model}, 
and weight matrix \code{W}. Returns a named vector of parameter estimates.
The default is \code{\link{parameterEstim.separate}}}

\item{estimator}{A function for estimating the parameters of one model matrix using
the data covariance matrix \code{S}, a model matrix \code{modelMatrix}, and a weight matrix
\code{W}. Disattenuated composite correlation matrix \code{C} and indicator composite 
covariance matrix \code{IC} are optional. Returns matrix of parameter estimates.
The default is \code{\link{estimator.ols}}}

\item{weightSign}{A function for resolving weight sign ambiguity based on the data covariance matrix
\code{S} and a weight matrix \code{W}.  Returns
a weight matrix \code{W}. See \code{\link{weightSign}}
for details.}

\item{outerEstim}{A function for calculating outer weights using the data covariance matrix
\code{S}, a weight matrix \code{W}, an inner weight matrix \code{E},
and a weight pattern \code{W.model}. Returns
a weight matrix \code{W}. See \code{\link{outerEstim}}.}

\item{innerEstim}{A function for calculating inner weights using  the data covariance matrix
\code{S}, a weight matrix \code{W}, and an inner model matrix \code{inner.mod}. Returns
an inner weight matrix \code{E}. The default is \code{\link{innerEstim.path}}.}

\item{convCheck}{A function that takes the old \code{Wold} and new weight \code{Wold} matrices and
returns a scalar that is compared against \code{tol} to check for convergence. The default
is \code{\link{convCheck.absolute}}.}

\item{optimCrit}{A function for calculating value for an optimization criterion based on a
\code{matrixpls} result object. Returns a scalar. The default is \code{\link{optimCrit.maximizeInnerR2}}.}

\item{reliabilities}{A function for calculating reliability estimates based on the 
data covariance matrix \code{S}, factor loading matrix \code{loadings}, and a weight matrix \code{W}.
Returns a vector of reliability estimates. The default is
\code{\link{reliabilityEstim.weightLoadingProduct}}}
}
\description{
The following describes all estimation function types used in \pkg{matrixpls} package.
}
