% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stitch_two_nets_template.R
\name{stitch_two_nets_template}
\alias{stitch_two_nets_template}
\title{Stitch a template-to-treated network and a treated-to-control network
into one two-part network.}
\usage{
stitch_two_nets_template(net1, net2, n_c, lambda, multiple = 1)
}
\arguments{
\item{net1}{A list of five vectors: startn, endn, ucap, cost, b.}

\item{net2}{A list of five vectors: startn, endn, ucap, cost, b.}

\item{n_c}{Number of control units.}

\item{lambda}{A penalty.}

\item{multiple}{Number of treated units matched to each unit in the template}
}
\value{
This function returns a list of five vectors:
startn, endn, ucap, cost, b.
}
\description{
This function takes as inputs a template-to-treated network,
one treated-to-control network, a tuning parameter lambda,
and number of controls, and constructs one two-part network out of them.
}
\details{
This function is of limited interest to users. Parameter lambda is a
weight given to the first part of the network, and a large lambda value
emphasizes resemblance to the template. Parameter multiple could be taken
as any integer number between 1 and floor(treated size / template size).
}
