% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/horvitzThompson.R
\name{horvitzThompson}
\alias{horvitzThompson}
\title{Compute the Horvitz-Thompson Estimator}
\usage{
horvitzThompson(
  y,
  pi = NULL,
  N = NULL,
  pi2 = NULL,
  var_est = FALSE,
  var_method = "LinHB",
  B = 1000,
  fpc = TRUE,
  messages = TRUE
)
}
\arguments{
\item{y}{A numeric vector of the sampled response variable.}

\item{pi}{A numeric vector of inclusion probabilities for each sampled unit in y.  If NULL, then simple random sampling without replacement is assumed.}

\item{N}{A numeric value of the population size. If NULL, it is estimated with the sum of the inverse of the pis.}

\item{pi2}{A square matrix of the joint inclusion probabilities.  Needed for the "LinHT" variance estimator.}

\item{var_est}{A logical indicating whether or not to compute a variance estimator.  Default is FALSE.}

\item{var_method}{The method to use when computing the variance estimator.  Options are a Taylor linearized technique: "LinHB"= Hajek-Berger estimator, "LinHH" = Hansen-Hurwitz estimator, "LinHTSRS" = Horvitz-Thompson estimator under simple random sampling without replacement, and "LinHT" = Horvitz-Thompson estimator or a resampling technique: "bootstrapSRS" = bootstrap variance estimator under simple random sampling without replacement. The default is "LinHB".}

\item{B}{The number of bootstrap samples if computing the bootstrap variance estimator.  Default is 1000.}

\item{fpc}{Default to TRUE, logical for whether or not the variance calculation should include a finite population correction when calculating the "LinHTSRS" or the "SRSbootstrap" variance estimator.}

\item{messages}{A logical indicating whether to output the messages internal to mase. Default is TRUE.}
}
\value{
List of output containing:

* pop_total: Estimate of population total.

* pop_mean: Estimate of population mean.

* pop_total_var: Estimated variance of population total estimate.

* pop_mean_var: Estimated variance of population mean estimate.
}
\description{
Calculate the Horvitz-Thompson Estimator for a finite population mean/proportion or total based on sample data collected from a complex sampling design.
}
\examples{
library(dplyr)
data(IdahoSamp)
data(IdahoPop)
xsample <- filter(IdahoSamp, COUNTYFIPS == "16055")
xpop <- filter(IdahoPop, COUNTYFIPS == "16055") 

horvitzThompson(y = xsample$BA_TPA_ADJ,
                N = xpop$npixels,
                var_est = TRUE,
                var_method = "LinHTSRS")

}
\references{
\insertRef{hor52}{mase}
}
