% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregTree.R
\name{gregTree}
\alias{gregTree}
\title{Compute a regression tree estimator}
\usage{
gregTree(y, x_sample, x_pop, pi = NULL, pi2 = NULL, var_est = FALSE,
  var_method = "lin_HB", B = 1000, p_value = 0.05, perm_reps = 500,
  bin_size = NULL, strata = NULL)
}
\arguments{
\item{y}{A numeric vector of the sampled response variable.}

\item{x_sample}{A data frame of the auxiliary data in the sample.}

\item{x_pop}{A data frame of population level auxiliary information. It must contain the same names as x_sample.}

\item{pi}{A numeric vector of inclusion probabilities for each sampled unit in y.  If NULL, then simple random sampling without replacement is assumed.}

\item{pi2}{A square matrix of the joint inclusion probabilities.  Needed for the "lin_HT" variance estimator.}

\item{var_est}{A logical indicating whether or not to compute a variance estimator.  Default is FALSE.}

\item{var_method}{The method to use when computing the variance estimator.  Options are a Taylor linearized technique: "lin_HB"= Hajek-Berger estimator, "lin_HH" = Hansen-Hurwitz estimator, "lin_HTSRS" = Horvitz-Thompson estimator under simple random sampling without replacement, and "lin_HT" = Horvitz-Thompson estimator or a resampling technique: "bootstrap_SRS" = bootstrap variance estimator under simple random sampling without replacement. The default is "lin_HB".}

\item{B}{The number of bootstrap samples if computing the bootstrap variance estimator.  Default is 1000.}

\item{p_value}{Designated p-value level to reject null hypothesis in permutation test used to fit the regression tree. Default value is 0.05.}

\item{perm_reps}{An integer specifying the number of permutations for each permutation test run to fit the regression tree. Default value is 500.}

\item{bin_size}{A integer specifying the minimum number of observations in each node.}

\item{strata}{A factor vector of the stratum membership.  If NULL, all units are put into the same stratum.  Must have same length as y.}
}
\value{
A list of output containing:
\itemize{
\item{pop_total: Estimate of population total}
\item{pop_mean: Estimate of the population mean}
\item{pop_total_var: Estimated variance of population total estimate}
\item{pop_mean_var: Estimated variance of population mean estimate}
\item{weights: Survey weights produced by regression tree}
\item{tree: rpms object}
}
}
\description{
Calculates a regression tree estimator for a finite population mean or total based on sample data collected from a complex sampling design and auxiliary population data.
}
\examples{
library(survey)
data(api)
gregTree(y = apisrs$api00, 
x_sample = apisrs[c("col.grad", "awards", "snum", "dnum", "cnum", "pcttest", "meals", "sch.wide")], 
x_pop = apipop[c("col.grad", "awards", "snum", "dnum", "cnum", "pcttest", "meals", "sch.wide")])

}
\references{
\insertRef{mcc17b}{mase}
}
\seealso{
\code{\link{greg}} for a linear or logistic regression model.
}
