% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.markovMSM.R
\name{print.markovMSM}
\alias{print.markovMSM}
\title{Pritting fits of "markovMSM" class.}
\usage{
\method{print}{markovMSM}(x, ...)
}
\arguments{
\item{x}{A object of "markovMSM" with the results of the AUC global or local
tests.}

\item{...}{For future methods.}
}
\value{
The formula and the methods of the Markov tests in Multi-state models.
}
\description{
Returns the formula and the methods of the Markov tests in
Multi-state models.
}
\examples{
library(markovMSM)
data("colonMSM")
db_wide<-colonMSM
positions<-list(c(2, 3), c(3), c())
namesStates =  c("Alive", "Rec",  "Death")
tmat <-transMatMSM(positions, namesStates)
timesNames = c(NA, "time1","Stime")
status=c(NA, "event1","event")
trans = tmat
db_long<- prepMSM(data=db_wide, trans, timesNames, status)
times=365
res<-AUC.test(db_long, db_wide, times=times, from=2, to=3, type='local', 
replicas=2, tmat = tmat)
print(res)

}
\references{
Soutinho G, Meira-Machado L (2021). Methods for checking the 
Markov condition in multi-state survival data. \emph{Computational Statistics}.
}
\author{
Gustavo Soutinho and Luis Meira-Machado.
}
