% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataframes.R
\name{unique_rows}
\alias{unique_rows}
\title{Unique rows}
\usage{
unique_rows(data, cols = NULL, from_last = FALSE, invert = FALSE)
}
\arguments{
\item{data}{A \code{data.frame}}

\item{cols}{Columns to compare against; when \code{NULL} selects all columns}

\item{from_last}{When \code{TRUE} returns the last row containing duplicates,
rather than the first}

\item{invert}{If \code{TRUE} returns the duplicated rows}
}
\value{
\code{data} will duplicates removes
}
\description{
Drops duplicated rows
}
\examples{
df <- quick_dfl(
  i = 1:4,
  a = rep(1:2, 2L),
  b = rep("a", 4L),
)

unique_rows(df, 2:3)
unique_rows(df, c("a", "b"), from_last = TRUE, invert = TRUE)
}
