% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapping.R
\name{text2mapping}
\alias{text2mapping}
\title{Convenient shorthand for specifying mappings with text strings}
\usage{
text2mapping(
  text,
  file = NULL,
  sep = "|",
  flip = FALSE,
  convert.na = TRUE,
  numericWherePossible = TRUE,
  ...
)
}
\arguments{
\item{text}{A multi-line string specifying a mapping with 2 columns (see examples).}

\item{file}{If \code{text} is missing, read from this file instead.}

\item{sep}{Character used as column separator.}

\item{flip}{If \code{TRUE}, flip the column order to To, From (default \code{FALSE}).}

\item{convert.na}{If \code{TRUE}, the string \code{"NA"} will be converted to
\code{NA}.}

\item{numericWherePossible}{If \code{TRUE}, the mapping will return a
\code{numeric} vector if the codomain contains only numbers.}

\item{...}{Further arguments passed to \code{\link[=mapping]{mapping()}}.}
}
\value{
A \code{\link{mapping}}.
}
\description{
Convenient shorthand for specifying mappings with text strings
}
\examples{
f <- text2mapping("
L | Low
M | Medium
H | High
")
f(warpbreaks$tension)
}
