% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.stationary.R
\name{boot.stationary}
\alias{boot.stationary}
\title{Generate Index for Stationary Bootstrapping}
\usage{
boot.stationary(N, p = 0.25)
}
\arguments{
\item{N}{the number of observations.}

\item{p}{parameter for geometric distribution with the size of each block.}
}
\value{
a vector of length \code{N} for moving block bootstrap sampling.
}
\description{
Assuming data being dependent with cardinality \code{N}, \code{boot.stationary} returns 
a vector of index that is used for stationary bootstrapping. To describe, starting points 
are drawn from uniform distribution over \code{1:N} and the size of each block is 
determined from geometric distribution with parameter \eqn{p}.
}
\examples{
## example : bootstrap confidence interval of mean and variances
vec.x = seq(from=0,to=10,length.out=1000)
vec.y = sin(1.21*vec.x) + 2*cos(3.14*vec.x) + rnorm(1000,sd=1.5)
data.mu  = mean(vec.y)
data.var = var(vec.y)

## apply stationary bootstrapping
nreps   = 496
vec.mu  = rep(0,nreps)
vec.var = rep(0,nreps)
for (i in 1:nreps){
   sample.id = boot.stationary(1000)
   sample.y  = vec.y[sample.id]
   vec.mu[i]  = mean(sample.y)
   vec.var[i] = var(sample.y)
   print(paste("iteration ",i,"/",nreps," complete.", sep=""))
}

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3), pty="s")
plot(vec.x, vec.y, type="l", main="1d signal")  # 1d signal
hist(vec.mu, main="mean CI", xlab="mu")         # mean
abline(v=data.mu, col="red", lwd=4)
hist(vec.var, main="variance CI", xlab="sigma") # variance
abline(v=data.var, col="blue", lwd=4)
par(opar)

}
\references{
\insertRef{politis_stationary_1994}{maotai}
}
