/*
 * Decompiled with CFR 0.152.
 */
package salvo.jesus.graph.algorithm;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import salvo.jesus.graph.Graph;
import salvo.jesus.graph.NullVisitor;
import salvo.jesus.graph.Vertex;
import salvo.jesus.graph.Visitor;
import salvo.jesus.graph.algorithm.GraphTraversal;

public class DepthFirstGraphTraversal
extends GraphTraversal {
    private Stack stack = new Stack();
    private Set seen;

    public DepthFirstGraphTraversal(Graph graph) {
        super(graph);
    }

    public int traverse(Vertex startat, List visited, Visitor visitor) {
        this.seen = new HashSet(visited);
        this.stack.push(startat);
        this.seen.add(startat);
        do {
            Vertex next = (Vertex)this.stack.pop();
            visited.add(next);
            if (!visitor.visit(next)) {
                this.clear();
                return -1;
            }
            List adjacentVertices = this.getAdjacentVertices(next);
            Iterator iterator = adjacentVertices.iterator();
            while (iterator.hasNext()) {
                Vertex adjacent = (Vertex)iterator.next();
                if (!this.seen.add(adjacent)) continue;
                this.stack.push(adjacent);
            }
        } while (!this.stack.isEmpty());
        this.clear();
        return 1;
    }

    private void clear() {
        this.stack.clear();
        this.seen = null;
    }

    protected List getAdjacentVertices(Vertex v) {
        return this.graph.getAdjacentVertices(v);
    }

    public List traverse(Vertex startat) {
        return this.traverse(startat, new NullVisitor());
    }

    public List traverse(Vertex startat, Visitor visitor) {
        ArrayList visited = new ArrayList(10);
        this.traverse(startat, visited, visitor);
        return visited;
    }
}

