magaxis <-
function(side=1:4,majorn=5,minorn=5,tcl=0.5,ratio=0.5,labels=TRUE,unlog='Auto',tline=0.5,mtline=2,xlab=NULL,ylab=NULL,box=FALSE,crunch=TRUE,logpretty=TRUE,...){
unloglist=unlog
labelslist=labels
crunchlist=crunch
logprettylist=logpretty
if(length(unlog)==1 & length(side)>1 & (unlog[1]==T | unlog[1]==F | unlog[1]=='Auto')){unloglist=rep(unlog,length(side))}
if(length(labels)==1 & length(side)>1){labelslist=rep(labels,length(side))}
if(length(crunch)==1 & length(side)>1){crunchlist=rep(crunch,length(side))}
if(length(logpretty)==1 & length(side)>1){logprettylist=rep(logpretty,length(side))}
if(unlog[1]=='x'){unloglist=rep(FALSE,length(side));unloglist[side %in% c(1,3)]=TRUE}
if(unlog[1]=='y'){unloglist=rep(FALSE,length(side));unloglist[side %in% c(2,4)]=TRUE}
if(unlog[1]=='xy' | unlog[1]=='yx'){unloglist=rep(TRUE,length(side))}

if(length(unloglist) != length(side)){stop('Length of unlog vector mismatches number of axes!')}
if(length(labelslist) != length(side)){stop('Length of labels vector mismatches number of axes!')}

for(i in 1:length(side)){
		currentside=side[i]
		unlog=unloglist[i]
		labels=labelslist[i]
		crunch=crunchlist[i]
		logprettylist=logpretty[i]
  		lims=par("usr")
  		if(currentside %in% c(1,3)){
  		lims=lims[1:2];if(par('xlog')){logged=T}else{logged=F}
  		}else{
  		lims=lims[3:4];if(par('ylog')){logged=T}else{logged=F}
  		}
        lims=sort(lims)

        if(unlog=='Auto'){if(logged){unlog=T}else{unlog=F}}
        if(logged | unlog){usemultloc=(10^lims[2])/(10^lims[1])<50}else{usemultloc=F}
        	  		
  		if(unlog){
        sci.tick=maglab(10^lims,n=majorn,log=T,exptext=T,crunch=crunch,logpretty=logpretty,usemultloc=usemultloc)
        major.ticks = log10(sci.tick$tickat)
  		uselabels = sci.tick$exp
  		labloc = log10(sci.tick$labat)
        if(usemultloc==F){minors = log10(pretty(10^major.ticks[1:2],minorn+2))-major.ticks[1]}
 		}
 		if(logged & unlog==F){
 		sci.tick=maglab(10^lims,n=majorn,log=T,exptext=F,crunch=crunch,logpretty=logpretty,usemultloc=usemultloc)
 		major.ticks = log10(sci.tick$tickat)
  		uselabels = sci.tick$exp
  		labloc = log10(sci.tick$labat)
 		if(usemultloc==F){minors = log10(pretty(10^major.ticks[1:2],minorn+2))-major.ticks[1]}
 		}
 		if(logged==F & unlog==F){
 		sci.tick=maglab(lims,n=majorn,log=F,exptext=F)
 		major.ticks = sci.tick$tickat
  		uselabels = sci.tick$exp
  		labloc = sci.tick$labat
  		minors = pretty(major.ticks[1:2],minorn+2)-major.ticks[1]
 		}

 		if(logged){axis(side=currentside,at=10^major.ticks,tcl=tcl,labels=FALSE,mgp=c(2,tline,0))}
 		else axis(side=currentside,at=major.ticks,tcl=tcl,labels=FALSE,mgp=c(2,tline,0))
 		
  		if(labels){
  		    if(logged){axis(side=currentside,at=10^labloc,tick=F,labels=uselabels,mgp=c(2,tline,0))}
  		    else axis(side=currentside,at=labloc,tick=F,labels=uselabels,mgp=c(2,tline,0))
  		}
  		
  		if(usemultloc==F){
  		minors = minors[-c(1,length(minors))]
  		minor.ticks = c(outer(minors, major.ticks, `+`))
		if(logged){axis(currentside,at=10^minor.ticks,tcl=tcl*ratio,labels=FALSE)}
		else axis(currentside,at=minor.ticks,tcl=tcl*ratio,labels=FALSE)
		}
    if(is.null(xlab)==F & currentside==1){mtext(xlab,1,line=mtline)}
    if(is.null(ylab)==F & currentside==2){mtext(ylab,2,line=mtline)}
}
if(box){box()}
}
