% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invoke.R
\name{invoke}
\alias{invoke}
\title{Manually run a pipeline regardless of schedule}
\usage{
invoke(schedule, pipe_name, resources = list(), ...)
}
\arguments{
\item{schedule}{object of type MaestroSchedule created using \code{build_schedule()}}

\item{pipe_name}{name of a single pipe name from the schedule}

\item{resources}{named list of shared resources made available to pipelines as needed}

\item{...}{other arguments passed to \code{run_schedule()}}
}
\value{
invisible
}
\description{
Instantly run a single pipeline from the schedule. This is useful for testing
purposes or if you want to just run something one-off.
}
\details{
Scheduling parameters such as the frequency, start time, and specifiers are ignored.
The pipeline will be run even if \code{maestroSkip} is present.
}
\examples{
if (interactive()) {
  pipeline_dir <- tempdir()
  create_pipeline("my_new_pipeline", pipeline_dir, open = FALSE)
  schedule <- build_schedule(pipeline_dir = pipeline_dir)

  invoke(schedule, "my_new_pipeline")
}
}
