% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-catalogue_functions.R
\name{is_taxonomy}
\alias{is_taxonomy}
\title{Test if an object is a valid taxonomy}
\usage{
is_taxonomy(object)
}
\arguments{
\item{object}{A potential taxonomy to be evaluated.}
}
\value{
A logical.
}
\description{
Confirms whether the input object is a valid taxonomy. This function mainly
helps validate input within other functions of the  package but could be
used to check if a taxonomy is valid.
}
\details{
A taxonomy is a classification schema that can be defined for variable
attributes. A taxonomy is usually extracted from an
\href{https://www.obiba.org/pages/products/opal/}{Opal environment}, and a
taxonomy object is a data frame that must contain at least the columns
\code{taxonomy}, \code{vocabulary}, and \code{terms}. Additional details about Opal
taxonomies are
\href{https://opaldoc.obiba.org/en/latest/web-user-guide/administration/taxonomies.html}{available online}.
}
\examples{
{

# use madshapR_DEMO provided by the package

is_taxonomy(madshapR_DEMO$taxonomy_PARIS)

}

}
