% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-dataset_functions.R
\name{is_dataset}
\alias{is_dataset}
\title{Test if an object is a valid dataset}
\usage{
is_dataset(object)
}
\arguments{
\item{object}{A potential dataset to be evaluated.}
}
\value{
A logical.
}
\description{
Tests if the input object is a valid dataset. This function mainly helps
validate input within other functions of the package but could be used
to check if a dataset is valid.
}
\details{
A dataset must be a data frame-like object and can be associated with a
data dictionary. If no data dictionary is provided, a minimum workable
data dictionary will be generated as needed by relevant functions.
An identifier \code{id} column for sorting can be specified by the user. If
specified, the \code{id} values must be non-missing and will be used in functions
that require it. If no identifier column is specified, indexing is handled
automatically by the function.
}
\examples{
{

# use DEMO_files provided by the package
# any data frame (or tibble) can be a dataset by definition.

is_dataset(DEMO_files$dataset_MELBOURNE_1)
is_dataset(iris)
is_dataset(AirPassengers)

}

}
\seealso{
For a better assessment, please use \code{\link[=dataset_evaluate]{dataset_evaluate()}}.
}
