% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-dictionaries_functions.R
\name{data_dict_filter}
\alias{data_dict_filter}
\title{Subset data dictionary by row values}
\usage{
data_dict_filter(
  data_dict,
  filter_var = NULL,
  filter_cat = NULL,
  filter_all = NULL
)
}
\arguments{
\item{data_dict}{A list of tibble(s) representing meta data to be
transformed.}

\item{filter_var}{Expressions that are defined in the element 'Variables' in
the data dictionary.}

\item{filter_cat}{Expressions that are defined in the element 'Categories' in
the data dictionary.}

\item{filter_all}{Expressions that are defined both in the 'Categories' and
'Variables' in the data dictionary.}
}
\value{
A list of tibble(s) identifying a workable data dictionary structure.
}
\description{
Subsets either or both the 'Variables' and 'Categories' elements of a data
dictionary. Rows are conserved if their values satisfy the condition.
This is a wrapper function analogous to \code{\link[dplyr:filter]{dplyr::filter()}}.
}
\details{
A data dictionary contains metadata about variables and can be associated
with a dataset. It must be a list of data frame-like objects with elements
named 'Variables' (required) and 'Categories' (if any). To be usable in any
function, the 'Variables' element must contain at least the 'name' column,
and the 'Categories' element must contain at least the 'variable' and 'name'
columns. To be considered as a minimum workable data dictionary, in
'Variables' the 'name' column must also have unique and non-null entries,
and in 'Categories' the combination of 'variable' and 'name' columns must
also be unique'.
}
\examples{
{

# use DEMO_files provided by the package

# Create a list of data dictionaries where the column 'table' is added to 
# refer to the associated dataset. The object created is not a 
# data dictionary per say, but can be used as a structure which can be 
# shaped into a data dictionary.
library(dplyr)

data_dict_list <- list()
data_dict_1 <-
  DEMO_files$dd_MELBOURNE_1_format_maelstrom \%>\%
  lapply(function(x){x \%>\% mutate(table = "MELBOURNE_1")})
data_dict_2 <- DEMO_files$dd_MELBOURNE_2_format_maelstrom \%>\%
  lapply(function(x){x \%>\% mutate(table = "MELBOURNE_2")})

data_dict_list <-
  list(Variables = bind_rows(data_dict_1$Variables,data_dict_2$Variables),
       Categories = bind_rows(data_dict_1$Categories,data_dict_2$Categories))

###### Example 1 search and filter through a column in 'Variables' element
data_dict_filter(data_dict_list,filter_var = "valueType == 'integer'")

###### Example 2 search and filter through a column in 'Categories' element
data_dict_filter(data_dict_list,filter_cat = "missing == TRUE")

###### Example 3 search and filter through a column in 'Variables' element.
# The column must exist in both 'Variables' and 'Categories' and have the 
# same meaning
data_dict_filter(data_dict_list,filter_all = "table == 'MELBOURNE_1'")

}

}
\seealso{
\code{\link[dplyr:filter]{dplyr::filter()}}
}
