% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-dictionaries_functions.R
\name{data_dict_collapse}
\alias{data_dict_collapse}
\title{Transform multi-row category column(s) to single rows and join to "Variables"}
\usage{
data_dict_collapse(
  data_dict,
  from = "Categories",
  to = "Variables",
  name_prefix = "Categories::"
)
}
\arguments{
\item{data_dict}{A list of tibble(s) representing meta data to be
transformed. Automatically generated if not provided.}

\item{from}{Symbol identifying the name of the element (tibble) to take
column(s) from. Default is 'Categories'.}

\item{to}{Symbol identifying the name of the element (tibble) to create
column(s) to. Default is 'Variables'.}

\item{name_prefix}{Character string of the prefix of columns of interest.
This prefix will be used to select columns, and to rename them in the 'to'
element. Default is 'Categories::'.}
}
\value{
A list of tibble(s) identifying a data dictionary.
}
\description{
Collapses a data dictionary element (the parameter 'from'),
into column(s) in another element (the parameter 'to')
If the element 'to' exists, and contains any column 'xx' or 'yy', these
columns will be added to the element 'from' under the names 'to:xx'
and 'to:yy'. (unique names will be generated if necessary). Each element
of these column will gather all information to process the reverse operation.
Separator of each element is the following structure :
'name = xx1 ; name = xx2'.
This function is mainly used to collapse the 'Categories' element into
columns in 'Variables'.
This function is the reversed operation of \code{\link[=data_dict_expand]{data_dict_expand()}}
}
\details{
A data dictionary contains metadata about variables and can be associated
with a dataset. It must be a list of data frame-like objects with elements
named 'Variables' (required) and 'Categories' (if any). To be usable in any
function, the 'Variables' element must contain at least the 'name' column,
and the 'Categories' element must contain at least the 'variable' and 'name'
columns. To be considered as a minimum workable data dictionary, in
'Variables' the 'name' column must also have unique and non-null entries,
and in 'Categories' the combination of 'variable' and 'name' columns must
also be unique'.
}
\examples{
{

# use DEMO_files provided by the package

data_dict <- DEMO_files$dd_MELBOURNE_1_format_maelstrom
data_dict_collapse(data_dict)

}

}
\seealso{
\code{\link[=data_dict_expand]{data_dict_expand()}}
}
