% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lpbwdensity_methods.R
\name{summary.lpbwdensity}
\alias{summary.lpbwdensity}
\title{Summary Method for Local Polynomial Density Bandwidth Selection}
\usage{
\method{summary}{lpbwdensity}(object, ...)
}
\arguments{
\item{object}{Class "lpbwdensity" object, obtained by calling \code{\link{lpbwdensity}}.}

\item{...}{Additional options, including (i) \code{grid} specifies a subset of grid points
to display the bandwidth; (ii) \code{gridIndex} specifies the indices of grid points
to display the bandwidth.}
}
\description{
The summary method for local polynomial density bandwidth selection objects.
}
\examples{
# Generate a random sample
set.seed(42); X <- rnorm(2000)

# Construct bandwidth
bw1 <- lpbwdensity(X)
summary(bw1)

# Display bandwidths for a subset of grid points
summary(bw1, grid=bw1$BW[4:10, "grid"])
summary(bw1, gridIndex=4:10)

}
\seealso{
\code{\link{lpbwdensity}} for data-driven bandwidth selection.

Supported methods: \code{\link{coef.lpbwdensity}}, \code{\link{print.lpbwdensity}}, \code{\link{summary.lpbwdensity}}.
}
\author{
Matias D. Cattaneo, Princeton University. \email{cattaneo@princeton.edu}.

Michael Jansson, University of California Berkeley. \email{mjansson@econ.berkeley.edu}.

Xinwei Ma (maintainer), University of California San Diego. \email{x1ma@ucsd.edu}.
}
