% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_layer_sp.R
\name{l_layer.Polygon}
\alias{l_layer.Polygon}
\title{Layer polygon in Polygon object}
\usage{
\method{l_layer}{Polygon}(widget, x, ...)
}
\arguments{
\item{widget}{widget widget path as a string or as an object handle}

\item{x}{an object defined in the \code{\link[sp:00sp]{sp}} class}

\item{...}{arguments forwarded to the relative \code{\link{l_layer}} function}
}
\value{
layer id
}
\description{
Methods to plot map data defined in the \code{\link[sp:00sp]{sp}}
  package
}
\details{
Note that currently loon does neither support holes and ring
  directions.
}
\examples{

if (interactive()) {

if (requireNamespace("rworldmap", quietly = TRUE)) {
    world <- rworldmap::getMap(resolution = "coarse")
    p <- l_plot()
    lmap <- l_layer(p, world, asSingleLayer=TRUE)
    l_scaleto_world(p)
    attr(lmap,'hole')
    attr(lmap,'NAME')
}
}
}
\references{
Applied Spatial Data Analysis with R by Bivand, Roger S. and
  Pebesma, Edzer and Gomez-Rubio and Virgilio
}
\seealso{
\code{\link[sp:00sp]{sp}}, \code{\link{l_layer}}
}
