% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loonGrob.R
\name{grid.loon}
\alias{grid.loon}
\title{Create and optionally draw a grid grob from a loon widget handle}
\usage{
grid.loon(target, name = NULL, gp = gpar(), draw = TRUE, vp = NULL)
}
\arguments{
\item{target}{either an object of class loon or a vector that specifies the
widget, layer, glyph, navigator or context completely. The widget is
specified by the widget path name (e.g. \code{'.l0.plot'}), the remaining
objects by their ids.}

\item{name}{a character identifier for the grob, or NULL. Used to find the grob on the display list
and/or as a child of another grob.}

\item{gp}{a gpar object, or NULL, typically the output from a call to the function gpar. 
This is basically a list of graphical parameter settings.}

\item{draw}{a logical value indicating whether graphics output should be produced.}

\item{vp}{a grid viewport object (or NULL).}
}
\value{
a grid grob of the loon plot
}
\description{
Create and optionally draw a grid grob from a loon widget handle
}
\examples{
\dontrun{
library(grid)
widget <- with(iris, l_plot(Sepal.Length, Sepal.Width))
grid.loon(widget)
}
}
\seealso{
\code{\link{loonGrob}}, \code{\link{plot.loon}}
}
