% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_plot3D.R
\name{l_plot3D.default}
\alias{l_plot3D.default}
\title{The default \code{l_plot} method to create 3d interactive scatterplot}
\usage{
\method{l_plot3D}{default}(x, y = NULL, z = NULL,
  axisScaleFactor = 1, color = "grey60", glyph = "ccircle",
  size = 4, active = TRUE, selected = FALSE, xlabel, ylabel, zlabel,
  title, showLabels = TRUE, showScales = FALSE, showGuides = TRUE,
  guidelines = "white", guidesBackground = "grey92",
  foreground = "black", background = "white", parent = NULL, ...)
}
\arguments{
\item{x}{the x, y and z arguments provide the x, y and z coordinates for the plot.
         Any reasonable way of defining the coordinates is acceptable.
         See the function xyz.coords for details.

         If supplied separately, they must be of the same length.}

\item{y}{the y coordinates of points in the plot,
optional if x is an appropriate structure.}

\item{z}{the z coordinates of points in the plot,
optional if x is an appropriate structure.}

\item{axisScaleFactor}{the amount to scale the axes at the centre of the rotation.
Default is 1.
    All numerical values are acceptable (0 removes the axes, < 0 inverts the direction of
    all axes.)}

\item{color}{colours of points; colours are repeated until matching the number points,}

\item{glyph}{shape of point; must be one of the primitive glyphs
             "circle", "ccircle", "ocircle", "square", "csquare", "osquare", "triangle", "ctriangle",
             "otriangle", "diamond", "cdiamond", or "odiamond".

             Prefixes "c" and "o" mean closed and open, respectively.
             Default is "ccircle" meaning a closed circle glyph.

             Non-primitive glyphs such as polygons, images, text, point ranges, and even interactive glyphs like
             serial axes glyphs may be added, but only after the plot has been created.}

\item{size}{size of the symbol (roughly in terms of area)}

\item{active}{a logical determining whether points appear or not
(default is TRUE for all points). If a logical vector is given of length
equal to the number of points, then it identifies which points appear (TRUE)
and which do not (FALSE).}

\item{selected}{a logical determining whether points appear selected at first
(default is FALSE for all points). If a logical vector is given of length
equal to the number of points, then it identifies which points are (TRUE)
and which are not (FALSE).}

\item{xlabel}{Label for the horizontal (x) axis. If missing,
one will be inferred from \code{x} if possible.}

\item{ylabel}{Label for the vertical (y) axis. If missing,
one will be inferred from \code{y} (or \code{x}) if possible.}

\item{zlabel}{Label for the third (perpendicular to the screen) (z) axis. If missing,
one will be inferred from \code{z} (or \code{x}) if possible.}

\item{title}{Title for the plot, default is an empty string.}

\item{showLabels}{logical to determine whether axes label (and title) should be presented.}

\item{showScales}{logical to determine whether numerical scales should
be presented on both axes.}

\item{showGuides}{logical to determine whether to present background guidelines
to help determine locations.}

\item{guidelines}{colour of the guidelines shown when \code{showGuides = TRUE} (default "white").}

\item{guidesBackground}{colour of the background to the guidelines shown when
\code{showGuides = TRUE} (default "grey92").}

\item{foreground}{foreground colour used by all other drawing (default "black").}

\item{background}{background colour used for the plot (default "white")}

\item{parent}{a valid Tk parent widget path. When the parent widget is
specified (i.e. not \code{NULL}) then the plot widget needs to be placed using
some geometry manager like \code{\link{tkpack}} or \code{\link{tkplace}} in
order to be displayed. See the examples below.}

\item{...}{named arguments to modify plot states.}
}
\description{
Creates an interactive 3d scatterplot. Also, if no loon
  inspector is open then the \code{l_plot3D} call will also open a loon
  inspector.
}
\details{
The scatterplot displays a number of direct interactions with the
  mouse and keyboard, these include: rotating, zooming towards the mouse cursor using
  the mouse wheel, panning by right-click dragging and various selection
  methods using the left mouse button such as sweeping, brushing and
  individual point selection. See the documentation for \code{\link{l_plot3D}}
  for more details about the interaction gestures.
}
\examples{

# default use as scatterplot

p1 <- with(quakes,
           l_plot3D(long, lat, depth)
           )

p2 <- with(quakes,
           l_plot3D(mag, stations, depth)
           )

# link the two plots p1 and p2
l_configure(p1, linkingGroup = "quakes", sync = "push")
l_configure(p2, linkingGroup = "quakes", sync = "push")

}
\seealso{
Other three-dimensional plotting functions: \code{\link{l_plot3D}},
  \code{\link{l_scale3D}}
}
\concept{three-dimensional plotting functions}
