% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_layer.R
\name{l_layer_getLabel}
\alias{l_layer_getLabel}
\title{Get layer label.}
\usage{
l_layer_getLabel(widget, layer)
}
\arguments{
\item{widget}{widget path or layer object of class \code{'l_layer'}}

\item{layer}{layer id. If the widget argument is of class \code{'l_layer'}
then the layer argument is not used}
}
\value{
Named vector of length 1 with layer label as value and layer id as
  name.
}
\description{
Layer labels are useful to identify layer in the layer 
  inspector. The layer label can be initially set at layer creation with the
  label argument.
}
\details{
Note that the layer label is not a state of the layer itself, 
  instead is information that is part of the layer collection (i.e. its 
  parent widget).
}
\examples{
p <- l_plot()
l1 <- l_layer_rectangle(p, x=0:1, y=0:1, label="a rectangle")
l_layer_getLabel(p, 'model')
l_layer_getLabel(p, l1)
}
\seealso{
\code{\link{l_layer}}, \code{\link{l_layer_relabel}}
}
