% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_glyphs.R
\name{l_glyph_add_text}
\alias{l_glyph_add_text}
\title{Add a Text Glyph}
\usage{
l_glyph_add_text(widget, text, label = "", ...)
}
\arguments{
\item{widget}{widget path as a string or as an object handle}

\item{text}{the text strings for each observartion. If the object is a factor
then the labels get extracted with \code{\link{as.character}}.}

\item{label}{label of a glyph (currently shown only in the glyph inspector)}

\item{...}{state arguments}
}
\description{
Each text glyph can be a multiline string.
}
\examples{
p <- l_plot(iris, color = iris$Species)
g <- l_glyph_add_text(p, iris$Species, "test_label")
p['glyph'] <- g
}
\seealso{
\code{\link{l_glyph_add}}

Other glyph functions: \code{\link{l_glyph_add.default}},
  \code{\link{l_glyph_add_image}},
  \code{\link{l_glyph_add_pointrange}},
  \code{\link{l_glyph_add_polygon}},
  \code{\link{l_glyph_add_serialaxes}},
  \code{\link{l_glyph_add}}, \code{\link{l_glyph_delete}},
  \code{\link{l_glyph_getLabel}},
  \code{\link{l_glyph_getType}}, \code{\link{l_glyph_ids}},
  \code{\link{l_glyph_relabel}},
  \code{\link{l_primitiveGlyphs}}
}
\concept{glyph functions}
