% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_layer.R
\name{l_layer_expunge}
\alias{l_layer_expunge}
\title{Delete a layer and all its descendants}
\usage{
l_layer_expunge(widget, layer)
}
\arguments{
\item{widget}{widget path or layer object of class \code{'l_layer'}}

\item{layer}{layer id. If the widget argument is of class \code{'l_layer'}
then the layer argument is not used}
}
\value{
0 if success otherwise the function throws an error
}
\description{
Delete a group layer and all it's descendants. Note that the
  \code{'model'} layer cannot be deleted.
}
\examples{

p <- l_plot()
g <- l_layer_group(p)
l1 <- l_layer_rectangle(p, x=0:1, y=0:1, parent=g, color="", linecolor="orange", linewidth=2)
l2 <- l_layer_line(p, x=c(0,.5,1), y=c(0,1,0), parent=g, color="blue")

l_layer_expunge(p, g)

# or l_layer_expunge(g)
}
\seealso{
\code{\link{l_layer}}, \code{\link{l_layer_delete}}
}
