% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_aspect.R
\name{l_setAspect}
\alias{l_setAspect}
\title{Set the aspect ratio of a plot}
\usage{
l_setAspect(widget, aspect, x, y)
}
\arguments{
\item{widget}{widget path as a string or as an object handle}

\item{aspect}{aspect ratio, optional, if omitted then the \code{x} and 
\code{y} arguments have to be specified.}

\item{x}{optional, if the \code{aspect} argument is missing then \code{x} and
\code{y} can be specified and the aspect ratio is calculted usding 
\code{y/x}.}

\item{y}{see description for \code{x} argument above}
}
\description{
The aspect ratio is defined by the ratio of the number of pixels
  for one data unit on the y axis and the number of pixels for one data unit
  on the x axes.
}
\examples{
p <- with(iris, l_plot(Sepal.Length ~ Sepal.Width, color=Species))

l_aspect(p)
l_setAspect(p, x = 1, y = 2) 
}
