% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/l_glyphs.R
\name{l_glyph_add_serialaxes}
\alias{l_glyph_add_serialaxes}
\title{Add a Serialaxes Glyph}
\usage{
l_glyph_add_serialaxes(widget, data, sequence, linewidth = 1,
  scaling = "variable", axesLayout = "radial", showAxes = FALSE,
  axesColor = "gray70", showEnclosing = FALSE, bboxColor = "gray70",
  label = "", ...)
}
\arguments{
\item{widget}{widget path as a string or as an object handle}

\item{data}{a data frame with numerical data only}

\item{sequence}{vector with variable names that defines the axes sequence}

\item{linewidth}{linewidth of outline}

\item{scaling}{one of 'variable', 'data', 'observation' or 'none' to specify
how the data is scaled. See Details for more information}

\item{axesLayout}{either \code{"serial"} or \code{"parallel"}}

\item{showAxes}{boolean to indicate whether axes should be shown or not}

\item{axesColor}{color of axes}

\item{showEnclosing}{boolean, circle (axesLayout=radial) or sqaure
(axesLayout=parallel) to show bounding box/circle of the glyph (or showing
unit circle or rectangle with height 1 if scaling=none)}

\item{bboxColor}{color of bounding box/circle}

\item{label}{label of a glyph (currently shown only in the glyph inspector)}

\item{...}{state arguments}
}
\description{
Serialaxes glyph show either a star glyph or a parralel
  coordinate glyph for each point.
}
\examples{
p <- with(olive, l_plot(oleic, stearic, color=Area))
gs <- l_glyph_add_serialaxes(p, data=olive[,-c(1,2)], showArea=FALSE)
p['glyph'] <- gs
}
