% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonparametric.R
\name{np_nll}
\alias{np_nll}
\title{Marginal log likelihood function of the nonparametric multinomial with censoring and truncation}
\usage{
np_nll(par, cens_lb, cens_ub, trunc_lb, trunc_ub, cens, trunc, weights)
}
\arguments{
\item{par}{vector of \code{D-1} parameters}

\item{cens_lb}{index of interval in which death occurs}

\item{cens_ub}{index of interval in which death occurs (if death is observed), or else the largest interval.}

\item{trunc_lb}{vector of largest index for the lower truncation}

\item{trunc_ub}{vector of smallest index for the upper truncation}
}
\value{
a scalar, the negative log likelihood value
}
\description{
Marginal log likelihood function of the nonparametric multinomial with censoring and truncation
}
\keyword{internal}
