% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ace.R
\name{ace}
\alias{ace}
\title{Estimating Average Causal Effects from a Fitted MTE Model.}
\usage{
ace(model, estimand = c("ate", "att", "atu", "mprte"), policy = 1)
}
\arguments{
\item{model}{A fitted \code{mte} model returned by \code{\link{mte}}.}

\item{estimand}{Type of estimand: \code{"ate"}, \code{"att"}, \code{"atu"}, or \code{"mprte"}.}

\item{policy}{An \code{\link{expression}} written as a function of \code{p}. This is used
only when \code{estimand="mprte"}.}
}
\value{
Estimate of ATE, ATT, ATU, or MPRTE
}
\description{
\code{ace} estimates Average Causal Effects (ACE) from a fitted MTE model.
The estimand can be average treatment effect (ATE), average treatment effect on the treated (ATT),
average treatment effect on the untreated (ATU), or the Marginal Policy Relevant
Treatment Effect (MPRTE) defined in Zhou and Xie (2019).
}
\examples{
mod <- mte(selection = d ~ x + z, outcome = y ~ x,
  data = toydata)

ate <- ace(mod, "ate")
att <- ace(mod, "att")
atu <- ace(mod, "atu")
mprte1 <- ace(mod, "mprte")
mprte2 <- ace(mod, "mprte", policy = p)
mprte3 <- ace(mod, "mprte", policy = 1-p)
mprte4 <- ace(mod, "mprte", policy = I(p<0.25))
c(ate, att, atu, mprte1, mprte2, mprte3, mprte4)

}
\references{
Heckman, James J., Sergio Urzua, and Edward Vytlacil. 2006.
  "\href{https://www.mitpressjournals.org/doi/abs/10.1162/rest.88.3.389}{Understanding Instrumental Variables in Models with Essential Heterogeneity.}"
  The Review of Economics and Statistics 88:389-432.

Zhou, Xiang and Yu Xie. 2019. "\href{https://www.journals.uchicago.edu/doi/abs/10.1086/702172}{Marginal Treatment Effects from A Propensity Score Perspective.}"
  Journal of Political Economy, 127(6): 3070-3084.

Zhou, Xiang and Yu Xie. 2020. "\href{https://journals.sagepub.com/doi/abs/10.1177/0081175019862593}{Heterogeneous Treatment Effects in the Presence of Self-selection:
  a Propensity Score Perspective.}" Sociological Methodology.
}
