% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierarchical_lm.R
\name{hierarchical_lm}
\alias{hierarchical_lm}
\title{Hierarchical Regression Analysis}
\usage{
hierarchical_lm(...)
}
\arguments{
\item{...}{The outputs of \code{lm()},
that is, one or more \code{lm}-class
objects. The outputs of other model
fitting functions may also be used,
but should be used with cautions.
Please refer to the "How it works"
section in "Details."}
}
\value{
If the models can be ordered in a
hierarchical way, the output is an
ANOVA table with the R-squared
estimate of each model, and the
R-squared change of each model
compared to the simpler model
preceding this model in the order.
The class of the output is
\code{hierarchical_lm}, with a print
method. If the models cannot be
ordered this way, \code{NA} is returned.
\subsection{How it works}{

It call \code{\link[=hierarchical]{hierarchical()}} firsts to
order the outputs for \code{\link[stats:lm]{stats::lm()}},
If they can be ordered in a
hierarchical way, they will be passed
to \code{\link[stats:anova]{stats::anova()}}. R-squared and
R-squared change will be computed
if they are available in the
\code{\link[=summary]{summary()}} method applied to each
model.

Therefore, in principle, this
function can also be used for the
outputs of other model fitting
functions if their outputs have
\code{\link[stats:anova]{stats::anova()}} and \code{\link[=summary]{summary()}}
methods.
}

\subsection{Check Datasets Used}{

The comparison is meaningful only
if all models are fitted to the
same datasets. There is not way
to guarantee this is the case, given
only the output of \code{\link[=lm]{lm()}}. However,
there are necessary conditions to
claim that the same datasets are used:
the number of cases are the same,
the means, variances, and covariances
of numerical variables, and the
frequency distributions of variables
common to two models are identical.
If at least one of these conditions
is not met, then two models must have
been fitted to two different datasets.

The function will check these
conditions and raise an error if
any of these necessary conditions
are not met.
}
}
\description{
Do hierarchical
regression analysis on two or more
models fitted by 'lm()'.
}
\details{
It conducted hierarchical
regression analysis on two or more
models fitted by \code{\link[stats:lm]{stats::lm()}}.
The models must be able to be ordered
from the simplest to the most complex,
with each more complex model formed
by adding one or more terms to the
simpler model.

ANOVA will be conducted to compare
each model with the next more
complex model in the order, with
R-squared change computed.
}
\examples{

dat <- data_test1
lm1 <- lm(y ~ x1 + x2, dat)
lm2 <- lm(y ~ x1 + x2 + x3 + x4, dat)
lm3 <- lm(y ~ x1 + cat1 + cat2 + x2 + x3 + x4, dat)
lm4 <- lm(y ~ x1 + x2*x3 + x4, dat)

hierarchical_lm(lm1, lm3, lm2)
hierarchical_lm(lm1, lm2, lm4)
# The following models will yield an error message:
tryCatch(hierarchical_lm(lm1, lm3, lm2, lm4), error = function(e) e)

}
\seealso{
\code{\link[stats:lm]{stats::lm()}}, \code{\link[=hierarchical]{hierarchical()}}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
