% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compact.R
\name{compact}
\alias{compact}
\title{Remove spurious variables and restrictions}
\usage{
compact(A, b, x = NULL, neq = nrow(A), nleq = 0, eps = 1e-08,
  remove_columns = TRUE, remove_rows = TRUE, deduplicate = TRUE,
  implied_equations = TRUE)
}
\arguments{
\item{A}{[\code{numeric}] matrix}

\item{b}{[\code{numeric}] vector}

\item{x}{[\code{numeric}] vector}

\item{neq}{[\code{numeric}] The first \code{neq} rows in \code{A} and
\code{b} are treated as linear equalities.}

\item{nleq}{[\code{numeric}] The \code{nleq} rows after \code{neq} are treated as
inequations of the form \code{a.x<=b}. All remaining rows are treated as strict inequations
of the form \code{a.x<b}.}

\item{eps}{[\code{numeric}] Anything with absolute value \code{< eps} is considered zero.}

\item{remove_columns}{[\code{logical}] Toggle remove spurious columns from \code{A} and variables from \code{x}}

\item{remove_rows}{[\code{logical}] Toggle remove spurious rows}

\item{deduplicate}{[\code{logical}] Toggle remove duplicate rows}

\item{implied_equations}{[\code{logical}] replace cases of \code{a.x<=b} and \code{a.x>=b} with
\code{a.x==b}.}
}
\value{
A \code{list} with the following elements.
\itemize{
  \item{\code{A}: The compactified version of input \code{A}}
  \item{\code{b}: The compactified version of input \code{b}}
  \item{\code{x}: The compactified version of input \code{x}}
  \item{\code{neq}: number of equations in new system}
  \item{\code{nleq}: number of inequations of the form \code{a.x<=b} in the new system}
  \item{\code{cols_removed}: [\code{logical}] indicates what elements of \code{x} (columns of \code{A}) have been removed}
}
}
\description{
A system of linear (in)equations can be compactified by removing
zero-rows and zero-columns (=variables). Such rows and columns may
arise after substitution (see \code{\link{subst_value}}) or eliminaton
of a variable (see \code{\link{eliminate}}).
}
\section{Details}{

It is assumend that the system of equations is in normalized form (see \code{link{normalize}}).
}

