library(lingtypology)
context("Tests for lang.aff function")

df <- data.frame(my_langs = c("Baltic"))

test_that("lang.aff", {
    expect_equal(lang.aff("Baltic"), c("Latvian", "East Latvian",
                                       "Standard Latvian", "Tamian",
                                       "Lithuanian", "Dzukish",
                                       "East Aukštaitian", "Suvalkietiskai",
                                       "Old Lithuanian", "North Samogitian",
                                       "South Samogitian", "West Samogitian",
                                       "Baltic Romani", "Chuxny",
                                       "Eastern Latvia-Lithuanian Romani",
                                       "North Russian Romani",
                                       "Polish Romani", "White Russian Romani"))
    expect_equal(lang.aff(df), c("Latvian", "East Latvian",
                                 "Standard Latvian", "Tamian",
                                 "Lithuanian", "Dzukish",
                                 "East Aukštaitian", "Suvalkietiskai",
                                 "Old Lithuanian", "North Samogitian",
                                 "South Samogitian", "West Samogitian",
                                 "Baltic Romani", "Chuxny",
                                 "Eastern Latvia-Lithuanian Romani",
                                 "North Russian Romani",
                                 "Polish Romani", "White Russian Romani"))
    expect_equal(lang.aff(c("Brythonic", "Goidelic")), c("Old-Middle Welsh",
                                                         "Middle Welsh",
                                                         "Old Welsh",
                                                         "Welsh",
                                                         "Northern Welsh",
                                                         "Patagonian Welsh",
                                                         "Southern Welsh",
                                                         "Breton",
                                                         "Cornouaillais",
                                                         "Leonais",
                                                         "Middle Breton",
                                                         "Old Breton",
                                                         "Tregorrois",
                                                         "Vannetais",
                                                         "Cornish",
                                                         "Modern Cornish",
                                                         "Old Cornish",
                                                         "Early Irish",
                                                         "Archaic Irish (7th century)",
                                                         "Early Goidelic (to 4th century)",
                                                         "Hiberno-Scottish Gaelic",
                                                         "Middle Irish (10-12th century)",
                                                         "Old Irish (8-9th century)",
                                                         "Primitive Irish (4-6th century)",
                                                         "Manx",
                                                         "Scottish Gaelic",
                                                         "Church Gaelic",
                                                         "East Sutherlandshire",
                                                         "Irish",
                                                         "Connacht",
                                                         "Donegal",
                                                         "Munster-Leinster"))
    expect_equal(lang.aff(c("Brythonic", "Goidelic"), list = TRUE),
                 list(c("Old-Middle Welsh",
                        "Middle Welsh",
                        "Old Welsh",
                        "Welsh",
                        "Northern Welsh",
                        "Patagonian Welsh",
                        "Southern Welsh",
                        "Breton",
                        "Cornouaillais",
                        "Leonais",
                        "Middle Breton",
                        "Old Breton",
                        "Tregorrois",
                        "Vannetais",
                        "Cornish",
                        "Modern Cornish",
                        "Old Cornish"),
                      c("Early Irish",
                        "Archaic Irish (7th century)",
                        "Early Goidelic (to 4th century)",
                        "Hiberno-Scottish Gaelic",
                        "Middle Irish (10-12th century)",
                        "Old Irish (8-9th century)",
                        "Primitive Irish (4-6th century)",
                        "Manx",
                        "Scottish Gaelic",
                        "Church Gaelic",
                        "East Sutherlandshire",
                        "Irish",
                        "Connacht",
                        "Donegal",
                        "Munster-Leinster")))
})
