% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getgrid.R
\name{getgrid}
\alias{getgrid}
\title{Transform a Polygon Layer to a Grid}
\usage{
getgrid(x, cellsize, var)
}
\arguments{
\item{x}{an sf polygon layer.}

\item{cellsize}{size of the side of a grid cell.}

\item{var}{name of the variable to transform to the grid. It can be a vector
of names.}
}
\value{
A data frame is returned.
}
\description{
Transform a polygon layer to a regular grid data.frame.
}
\examples{
library(linemap)
library(sf)
Bretagne <- st_read(system.file("gpkg/geofla.gpkg", package = "linemap"),
                    layer = "Bretagne")
France <- st_read(system.file("gpkg/geofla.gpkg", package = "linemap"),
                  layer = "France")
# example on an extract of dataset
cotedarmor <- Bretagne[Bretagne$CODE_DEPT == 22, ]
cota <- getgrid(x = cotedarmor, cellsize = 1750, var = "POPULATION")
opar <- par(mar = c(0,0,0,0))
plot(st_geometry(France), col="lightblue3", border = NA, bg = "lightblue2",
     xlim = c(min(cota$X), max(cota$X)), ylim= c(min(cota$Y), max(cota$Y)))
linemap(x = cota, var = "POPULATION", k = 5, threshold = 1,
        col = "lightblue3", border = "white", lwd = 0.8,
        add = TRUE)
par(opar)


\donttest{
# example on the full dataset
Bretagne_grid <- getgrid(x = Bretagne, cellsize = 1750, var = "POPULATION")
opar <- par(mar = c(0,0,0,0))
plot(st_geometry(France), col="lightblue3", border = NA, bg = "lightblue2",
     xlim = range(Bretagne_grid$X), ylim= range(Bretagne_grid$Y))
linemap(x = Bretagne_grid, var = "POPULATION", k = 5, threshold = 1,
        col = "lightblue3", border = "white", lwd = 0.8,
        add = TRUE)
par(opar)
}
}
