% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_diagnose.R
\name{gg_diagnose}
\alias{gg_diagnose}
\title{Plot all diagnostic plots given fitted linear regression line.}
\usage{
gg_diagnose(fitted.lm, theme = NULL, ncol = NA, plot.all = TRUE,
  scale.factor = 0.5, boxcox = FALSE, max.per.page = NA)
}
\arguments{
\item{fitted.lm}{lm object that contains fitted regression}

\item{theme}{ggplot graphing style using `ggplot::theme()`. A ggplot graphing style to apply to all plots. Default to null.}

\item{ncol}{specify number of columns in resulting plot per page. Default to make a square matrix of the output.}

\item{plot.all}{logical; determine whether plot will be returned as
an arranged grid. When set to false, the function
will return a list of diagnostic plots. Parameter defaults to TRUE.}

\item{scale.factor}{numeric; scales the point size, linewidth, labels in all diagnostic plots to allow optimal viewing. Defaults to 0.5.}

\item{boxcox}{logical; detemine whether boxcox plot will be included. Parameter defaults to FALSE.}

\item{max.per.page}{numeric; maximum number of plots allowed in one page.}
}
\value{
An arranged grid of linear model diagnostics plots in ggplot.
If plot.all is set to FALSE, a list of ggplot objects will be returned instead.
Name of the plots are set to respective variable names.
}
\description{
Plot all diagnostic plots given fitted linear regression line.
}
\examples{
library(MASS)
data(Cars93)
# a regression with categorical variable
cars_lm <- lm(Price ~ Passengers + Length + RPM + Origin, data = Cars93)
gg_diagnose(cars_lm)
# customize which diagnostic plot is included
plots <- gg_diagnose(cars_lm, plot.all = FALSE)
names(plots)     # get name of the plots
exclude_plots <- plots[-c(1, 3) ]    #exclude certain diagnostics plots
include_plots <- plots[c(1, 3)]      # include certain diagnostics plots
plot_all(exclude_plots)              # make use of plot_all() in lindia
plot_all(include_plots)
}
