% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L_corr.R
\name{L_corr}
\alias{L_corr}
\title{Likelihood Support for Correlation}
\usage{
L_corr(xv, yv, null=0, exp.r=NULL, L.int=2, alpha=.05,
toler=0.0001, logplot=FALSE, supplot=-10, verb=TRUE)
}
\arguments{
\item{xv}{a numeric vector.}

\item{yv}{a numeric vector the same length as xv.}

\item{null}{the null value, default = 0.}

\item{exp.r}{a specified correlation (could be expected value for the study), default = NULL.}

\item{L.int}{likelihood interval given as support values, e.g. 2 or 3, default = 2.}

\item{alpha}{the significance level used, 1 - alpha interval calculated, default = 0.05.}

\item{toler}{the desired accuracy using optimise, default = 0.0001.}

\item{logplot}{plot vertical axis as log likelihood, default = FALSE}

\item{supplot}{set minimum likelihood display value in plot, default = -10}

\item{verb}{show output, default = TRUE.}
}
\value{
$obs.r - observed correlation.

$S.0 - support for observed correlation versus the null.

$S.1 - support for the specified correlation versus observed correlation.

$S.10 - support for the specified correlation versus the null value.

$exp.r - the specified correlation.

$N - the sample size.

$p.value - the p value for significance test versus 0.

$like.int - the likelihood interval.

$like.int.spec - the specified likelihood interval in terms of support.

$conf.int - the \% confidence interval for the correlation.

$alpha.spec - the specified alpha for the \% confidence interval.
}
\description{
This function calculates the support for a correlation from 2 vectors of data.
An expected correlation can be specified and the support calculated for this relative to the observed
and the null (which is assumed to be 0, but can also be specified) values. A likelihood function
is plotted for the obtained correlation with a likelihood interval added and expected correlation,
if specified. Conventional p value is also given.
}
\examples{
# for heptathlon example, p 104
m200 <- c(22.6,	23.7,	23.1,	23.6,	23.6,	23.6,	25.5,
23.9,	24.5,	23.9,	24.9,	24.8,	24.7,
25.0,	24.6,	24.9,	25.0,	25.6,	24.8,
25.5,	25.7,	24.9,	26.6,	25.2,	26.2)
m800 <- c(128.5,	126.1,	124.2,	132.5,
134.7,	132.5,	138.5,	127.9,	133.7,	132.2,
136.1,	142.8,	125.8, 131.5,	137.1,	134.9,
146.7,	133.9,	146.4,	144.0,	133.4,
138.0,	139.2,	137.3,	163.4)
m=L_corr(m200, m800, null=0, exp.r=.4, L.int=3, alpha=.05,
toler=0.0001, logplot=FALSE, supplot=-10, verb=TRUE)
m
#Note: the support for observed vs 0 is different from book (5.776 vs 5.700)
#due to differences in calculation of r by Excel and R

}
\references{
Cahusac, P.M.B. (2020) Evidence-Based Statistics, Wiley, ISBN : 978-1119549802

Royall, R. M. (1997). Statistical evidence: A likelihood paradigm. London: Chapman & Hall, ISBN : 978-0412044113

Edwards, A.W.F. (1992) Likelihood, Johns Hopkins Press, ISBN : 978-0801844430
}
\keyword{Likelihood;}
\keyword{correlation;}
\keyword{interval}
\keyword{likelihood}
\keyword{support;}
