% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L_OR.R
\name{L_OR}
\alias{L_OR}
\title{Likelihood Support for Odds Ratio (OR)}
\usage{
L_OR(table, null=1, exp.OR=NULL, L.int=2, alpha=0.05, cc=FALSE, toler=0.0001, verb=TRUE)
}
\arguments{
\item{table}{a 2 x 2 matrix or contingency table containing counts.}

\item{null}{the value against which the obtained OR is tested, default = 1.}

\item{exp.OR}{an expected or hypothetical OR.}

\item{L.int}{likelihood interval given as support values, e.g. 2 or 3, default = 2.}

\item{alpha}{the significance level used, 1 - alpha interval calculated, default = 0.05.}

\item{cc}{logical indicating whether to apply continuity correction, default = FALSE.}

\item{toler}{the desired accuracy using optimise, default = 0.0001.}

\item{verb}{show output, default = TRUE.}
}
\value{
$S.val - support for observed OR from expected.

$df - degrees of freedom.

$exp.OR - expected OR.

$S.exp.ORvsObs - support for expected OR versus observed.

$S.exp.ORvsNull - support for expected OR versus the null.

$L.int - likelihood interval of observed OR for specified level of support.

$S_int - specified likelihood interval in units of support.

$observed - observed frequencies.

$expected - the expected values for null hypothesis of no interaction.

$chi.sq - chi-squared statistic.

$corrected - whether chi-squared was corrected, default = FALSE.

$p.value - p value.

$residuals - the Pearson residuals.

$alpha - specified significance level.

$conf.int - likelihood-based confidence interval for observed RR.

$all.err.acc - error accuracy for each application of the optimize function.
}
\description{
This function calculates the support for an OR from a 2 x 2 categorical data table.
An expected OR can be specified and the support calculated for this relative to the observed
and null (which is assumed to be 1, but can also be specified) values. A likelihood function
is plotted for the obtained OR with a specified likelihood interval, and expected OR,
if specified.
Chi-squared statistics are also provided and a likelihood-based \% confidence interval.
It uses the optimize function to locate desired limits for both intervals and other
support calculations.
}
\examples{
# for folic acid and neural tube defects example, p 146
tab <- as.table(rbind(c(6,587),c(21,581)))
dimnames(tab) <- list(Treatment=c("Folic acid","None"),Defect=c("Yes","No"))
L_OR(tab, exp.OR = 0.5, L.int = 2)

}
\references{
Aitkin, M. et al (1989) Statistical Modelling in GLIM, Clarendon Press, ISBN : 978-0198522041

Cahusac, P.M.B. (2020) Evidence-Based Statistics, Wiley, ISBN : 978-1119549802

Royall, R. M. (1997). Statistical evidence: A likelihood paradigm. London: Chapman & Hall, ISBN : 978-0412044113

Edwards, A.W.F. (1992) Likelihood, Johns Hopkins Press, ISBN : 978-0801844430

Dienes, Z. (2008) Understanding Psychology as a Science: An Introduction to Scientific and Statistical
Inference, Palgrave, MacMillan, ISBN : 978-0230542303
}
\keyword{Likelihood;}
\keyword{confidence}
\keyword{interval}
\keyword{interval;}
\keyword{likelihood}
\keyword{odds}
\keyword{ratio;}
\keyword{support;}
