% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io_readLAS.R, R/io_readXLAS.R
\name{readLAS}
\alias{readLAS}
\alias{readALSLAS}
\alias{readTLSLAS}
\alias{readUAVLAS}
\alias{readDAPLAS}
\alias{readMSLAS}
\title{Read .las or .laz files}
\usage{
readLAS(files, select = "*", filter = "")

readALSLAS(files, select = "*", filter = "")

readTLSLAS(files, select = "*", filter = "")

readUAVLAS(files, select = "*", filter = "")

readDAPLAS(files, select = "*", filter = "")

readMSLAS(files1, files2, files3, select = "*", filter = "")
}
\arguments{
\item{files}{characters. Path(s) to one or several a file(s). Can also be a
\link[=LAScatalog-class]{LAScatalog} object.}

\item{select}{character. Read only attributes of interest to save memory (see details).}

\item{filter}{character. Read only points of interest to save memory (see details).}

\item{files1, files2, files3}{characters. Path(s) to one or several a file(s). Each argument being
one channel (see section 'Multispectral data').}
}
\value{
A LAS object
}
\description{
Reads .las or .laz files into an object of class \link[=LAS-class]{LAS}. If several files are read at
once the returned LAS object is considered as one LAS file. The optional parameters enable the user
to save a substantial amount of memory by choosing to load only the attributes or points of interest.
LAS formats 1.1 to 1.4 are supported. Point Data Record Format 0 to 10 are supported.\cr\cr
\code{readLAS} is the original function and always works. Using one of the \code{read*LAS} functions
adds information to the returned object to register a point-cloud type. Registering the correct point
type \strong{may} improve the performance of some functions by enabling users to select an appropriate spatial index.
See \link[=lidR-spatial-index]{spatial indexing}. Notice that by legacy and for backwards-compatibility reasons,
\code{readLAS()} and \code{readALSLAS()} are equivalent because lidR was originally designed for ALS and thus the
original function \code{readLAS()} was (supposedly) used for ALS. Reading a TLS dataset with \code{readLAS()} instead
of \code{readTLSLAS()} is perfectly valid and performs similarly to versions \verb{<= 3.0.0}, with neither
performance degradation nor improvements.
}
\details{
\strong{Select:} the 'select' argument specifies the data that will actually be loaded. For example,
'xyzia' means that the x, y, and z coordinates, the intensity and the scan angle will be loaded.
The supported entries are t - gpstime, a - scan angle, i - intensity, n - number of returns,
r - return number, c - classification, s - synthetic flag, k - keypoint flag, w - withheld flag,
o - overlap flag (format 6+), u - user data, p - point source ID, e - edge of flight line flag,
d - direction of scan flag, R - red channel of RGB color, G - green channel of RGB color,
B - blue channel of RGB color, N - near-infrared channel, C - scanner channel (format 6+),
W - Full waveform.
Also numbers from 1 to 9 for the extra bytes data numbers 1 to 9. 0 enables all extra bytes to be
loaded and '*' is the wildcard that enables everything to be loaded from the LAS file. \cr
Note that x, y, z are implicit and always loaded. 'xyzia' is equivalent to 'ia'.\cr\cr
\strong{Filter:} the 'filter' argument allows filtering of the point cloud while reading files.
This is much more efficient than \link{filter_poi} in many ways. If the desired filters are known
before reading the file, the internal filters should always be preferred. The available filters are
those from \code{LASlib} and can be found by running the following command: \code{readLAS(filter = "-help")}.
(see also \link[rlas:read.las]{rlas::read.las}). From \code{rlas} v1.3.6 the transformation commands
can also be passed via the argument filter.
}
\section{Full waveform}{

With most recent versions of the `rlas` package, full waveform (FWF) can be read and `lidR`
provides some compatible functions. However, the support of FWF is still a work-in-progress
in the `rlas` package. How it is read, interpreted and represented in R may change. Consequently,
tools provided by `lidR` may also change until the support of FWF becomes mature and
stable in `rlas`. See also \link[rlas:read.las]{rlas::read.las}.\cr\cr
Remember that FWF represents an insanely huge amount of data. It terms of memory it is like
having between 10 to 100 times more points. Consequently, loading FWF data in R should be
restricted to relatively small point clouds.
}

\section{Multispectral data}{

Multispectral laser data are often stored in 3 different files. If this is the case
\code{readMSLAS} reads the .las or .laz files of each channel and merges them into
an object of class \link[=LAS-class]{LAS} and takes care of attributing an ID to each
channel. If the multisprectral point cloud is already stored in a single file
leave \code{file2} and \code{file3} missing.
}

\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
las = readLAS(LASfile)
las = readLAS(LASfile, select = "xyz")
las = readLAS(LASfile, select = "xyzi", filter = "-keep_first")
las = readLAS(LASfile, select = "xyziar", filter = "-keep_first -drop_z_below 0")

# Negation of attributes is also possible (all except intensity and angle)
las = readLAS(LASfile, select = "* -i -a")
}
