% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_metrics.R
\name{gap_fraction_profile}
\alias{gap_fraction_profile}
\title{Gap fraction profile}
\usage{
gap_fraction_profile(z, dz = 1, z0 = 2)
}
\arguments{
\item{z}{vector of positive z coordinates}

\item{dz}{numeric. The thickness of the layers used (height bin)}

\item{z0}{numeric. The bottom limit of the profile}
}
\value{
A data.frame containing the bin elevations (z) and the gap fraction for each bin (gf)
}
\description{
Computes the gap fraction profile using the method of Bouvier et al. (see reference)
}
\details{
The function assesses the number of laser points that actually reached the layer
z+dz and those that passed through the layer [z, z+dz]. By definition the layer 0
will always return 0 because no returns pass through the ground. Therefore, the layer 0 is removed
from the returned results.
}
\examples{
z = c(rnorm(1e4, 25, 6), rgamma(1e3, 1, 8)*6, rgamma(5e2, 5,5)*10)
z = z[z<45 & z>0]

hist(z, n=50)

gapFraction = gap_fraction_profile(z)

plot(gapFraction, type="l", xlab="Elevation", ylab="Gap fraction")
}
\references{
Bouvier, M., Durrieu, S., Fournier, R. a, & Renaud, J. (2015).  Generalizing predictive models of forest inventory attributes using an area-based approach with airborne las data. Remote Sensing of Environment, 156, 322-334. http://doi.org/10.1016/j.rse.2014.10.004
}
\seealso{
\link[lidR:LAD]{LAD}
}
